/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.writer;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.writer.AbstractOSMWriter;

public class O5mMapWriter
extends AbstractOSMWriter {
    private static final int NODE_DATASET = 16;
    private static final int WAY_DATASET = 17;
    private static final int REL_DATASET = 18;
    private static final int BBOX_DATASET = 219;
    private static final int HEADER_DATASET = 224;
    private static final int EOD_FLAG = 254;
    private static final int RESET_FLAG = 255;
    private static final int STW__TAB_MAX = 15000;
    private static final int STW_HASH_TAB_MAX = 30011;
    private static final int STW_TAB_STR_MAX = 250;
    private static final String[] REL_REF_TYPES = new String[]{"0", "1", "2"};
    private static final double FACTOR = 1.0E7;
    private OutputStream os;
    private byte[][][] stw__tab;
    private byte[] s1Bytes;
    private byte[] s2Bytes;
    private long lastNodeId;
    private long lastWayId;
    private long lastRelId;
    private long[] lastRef;
    private int lastLon;
    private int lastLat;
    private int lastWrittenDatasetType = 0;
    private short stw__tabi = 0;
    private short[] stw__hashtab;
    private short[] stw__tabprev;
    private short[] stw__tabnext;
    private short[] stw__tabhash;
    private byte[] numberConversionBuf;
    private static final Map<String, byte[]> wellKnownTagKeys = new HashMap<String, byte[]>(60, 0.25f);
    private static final Map<String, byte[]> wellKnownTagVals = new HashMap<String, byte[]>(20, 0.25f);

    public O5mMapWriter(Area bounds, File outputDir, int mapId, int extra) {
        super(bounds, outputDir, mapId, extra);
    }

    private void reset() throws IOException {
        this.os.write(255);
        this.resetVars();
    }

    private void resetVars() {
        this.lastNodeId = 0L;
        this.lastWayId = 0L;
        this.lastRelId = 0L;
        this.lastRef[0] = 0L;
        this.lastRef[1] = 0L;
        this.lastRef[2] = 0L;
        this.lastLon = 0;
        this.lastLat = 0;
        this.stw__tab = new byte[2][15000][];
        this.stw_reset();
    }

    @Override
    public void initForWrite() {
        this.stw__hashtab = new short[30011];
        this.stw__tabprev = new short[15000];
        this.stw__tabnext = new short[15000];
        this.stw__tabhash = new short[15000];
        this.lastRef = new long[3];
        this.numberConversionBuf = new byte[60];
        this.resetVars();
        String filename = String.format(Locale.ROOT, "%08d.o5m", this.mapId);
        try {
            this.os = new BufferedOutputStream(new FileOutputStream(new File(this.outputDir, filename)));
            this.os.write(255);
            this.writeHeader();
            this.writeBBox();
        }
        catch (IOException e) {
            System.out.println("Could not open or write file header. Reason: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void writeHeader() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] id = new byte[]{111, 53, 109, 50};
        stream.write(id);
        this.writeDataset(224, stream);
    }

    private void writeBBox() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeSignedNum((long)(Utils.toDegrees(this.bounds.getMinLong()) * 1.0E7), stream);
        this.writeSignedNum((long)(Utils.toDegrees(this.bounds.getMinLat()) * 1.0E7), stream);
        this.writeSignedNum((long)(Utils.toDegrees(this.bounds.getMaxLong()) * 1.0E7), stream);
        this.writeSignedNum((long)(Utils.toDegrees(this.bounds.getMaxLat()) * 1.0E7), stream);
        this.writeDataset(219, stream);
    }

    private void writeDataset(int fileType, ByteArrayOutputStream stream) throws IOException {
        this.os.write(fileType);
        this.writeUnsignedNum(stream.size(), this.os);
        stream.writeTo(this.os);
        this.lastWrittenDatasetType = fileType;
    }

    @Override
    public void finishWrite() {
        try {
            this.os.write(254);
            this.os.close();
            this.stw__hashtab = null;
            this.stw__tabprev = null;
            this.stw__tabnext = null;
            this.stw__tabhash = null;
            this.lastRef = null;
            this.numberConversionBuf = null;
            this.stw__tab = null;
        }
        catch (IOException e) {
            System.out.println("Could not write end of file: " + e);
        }
    }

    @Override
    public void write(Node node) throws IOException {
        if (this.lastWrittenDatasetType != 16) {
            this.reset();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        long delta = node.getId() - this.lastNodeId;
        this.lastNodeId = node.getId();
        this.writeSignedNum(delta, stream);
        this.writeVersion(node, stream);
        int o5Lon = (int)(node.getLon() * 1.0E7);
        int o5Lat = (int)(node.getLat() * 1.0E7);
        int deltaLon = o5Lon - this.lastLon;
        this.lastLon = o5Lon;
        int deltaLat = o5Lat - this.lastLat;
        this.lastLat = o5Lat;
        this.writeSignedNum(deltaLon, stream);
        this.writeSignedNum(deltaLat, stream);
        this.writeTags(node, stream);
        this.writeDataset(16, stream);
    }

    @Override
    public void write(Way way) throws IOException {
        if (this.lastWrittenDatasetType != 17) {
            this.reset();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        long delta = way.getId() - this.lastWayId;
        this.lastWayId = way.getId();
        this.writeSignedNum(delta, stream);
        this.writeVersion(way, stream);
        ByteArrayOutputStream refStream = new ByteArrayOutputStream();
        LongArrayList refs = way.getRefs();
        int numRefs = refs.size();
        for (int i = 0; i < numRefs; ++i) {
            long ref = refs.getLong(i);
            delta = ref - this.lastRef[0];
            this.lastRef[0] = ref;
            this.writeSignedNum(delta, refStream);
        }
        this.writeUnsignedNum(refStream.size(), stream);
        refStream.writeTo(stream);
        this.writeTags(way, stream);
        this.writeDataset(17, stream);
    }

    @Override
    public void write(Relation rel) throws IOException {
        if (this.lastWrittenDatasetType != 18) {
            this.reset();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(256);
        long delta = rel.getId() - this.lastRelId;
        this.lastRelId = rel.getId();
        this.writeSignedNum(delta, stream);
        this.writeVersion(rel, stream);
        ByteArrayOutputStream memStream = new ByteArrayOutputStream(256);
        for (Relation.Member mem : rel.getMembers()) {
            this.writeRelRef(mem, memStream);
        }
        this.writeUnsignedNum(memStream.size(), stream);
        memStream.writeTo(stream);
        this.writeTags(rel, stream);
        this.writeDataset(18, stream);
    }

    private void writeRelRef(Relation.Member mem, ByteArrayOutputStream memStream) throws IOException {
        int refType = 0;
        String type = mem.getType();
        if ("node".equals(type)) {
            refType = 0;
        } else if ("way".equals(type)) {
            refType = 1;
        } else if ("relation".equals(type)) {
            refType = 2;
        } else assert (false);
        long delta = mem.getRef() - this.lastRef[refType];
        this.lastRef[refType] = mem.getRef();
        this.writeSignedNum(delta, memStream);
        this.stw_write(REL_REF_TYPES[refType] + mem.getRole(), null, memStream);
    }

    private void writeVersion(Element element, OutputStream stream) throws IOException {
        if (this.versionMethod == 1) {
            stream.write(0);
            return;
        }
        int version = 1;
        if (this.versionMethod == 3) {
            version = element.getVersion();
        }
        if (version != 0) {
            this.writeUnsignedNum(version, stream);
        }
        stream.write(0);
    }

    private void writeTags(Element element, OutputStream stream) throws IOException {
        if (!element.hasTags()) {
            return;
        }
        Iterator<Element.Tag> it = element.tagsIterator();
        while (it.hasNext()) {
            Element.Tag entry = it.next();
            this.stw_write(entry.key, entry.value, stream);
        }
    }

    private void stw_write(String s1, String s2, OutputStream stream) throws IOException {
        short i;
        this.s1Bytes = wellKnownTagKeys.get(s1);
        if (this.s1Bytes == null) {
            this.s1Bytes = s1.getBytes(StandardCharsets.UTF_8);
        }
        if (s2 != null) {
            this.s2Bytes = wellKnownTagVals.get(s2);
            if (this.s2Bytes == null) {
                this.s2Bytes = s2.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            this.s2Bytes = null;
        }
        int ref = -1;
        int hash = this.stw_hash(s1, s2);
        if (hash >= 0 && (i = this.stw__hashtab[hash]) >= 0) {
            ref = this.stw__getref(i);
        }
        if (ref >= 0) {
            this.writeUnsignedNum(ref, stream);
            return;
        }
        stream.write(0);
        stream.write(this.s1Bytes);
        stream.write(0);
        if (this.s2Bytes != null) {
            stream.write(this.s2Bytes);
            stream.write(0);
        }
        if (hash < 0) {
            return;
        }
        short h0 = this.stw__tabhash[this.stw__tabi];
        if (h0 >= 0) {
            if (this.stw__tabnext[this.stw__tabi] == this.stw__tabi) {
                this.stw__hashtab[h0] = -1;
            } else {
                this.stw__hashtab[h0] = this.stw__tabnext[this.stw__tabi];
                this.stw__tabprev[this.stw__tabnext[this.stw__tabi]] = this.stw__tabprev[this.stw__tabi];
                this.stw__tabnext[this.stw__tabprev[this.stw__tabi]] = this.stw__tabnext[this.stw__tabi];
            }
        }
        this.stw__tab[0][this.stw__tabi] = this.s1Bytes;
        this.stw__tab[1][this.stw__tabi] = this.s2Bytes;
        i = this.stw__hashtab[hash];
        if (i < 0) {
            this.stw__tabprev[this.stw__tabi] = this.stw__tabnext[this.stw__tabi] = this.stw__tabi;
        } else {
            this.stw__tabnext[this.stw__tabi] = i;
            this.stw__tabprev[this.stw__tabi] = this.stw__tabprev[i];
            this.stw__tabnext[this.stw__tabprev[this.stw__tabi]] = this.stw__tabi;
            this.stw__tabprev[i] = this.stw__tabi;
        }
        this.stw__hashtab[hash] = this.stw__tabi;
        this.stw__tabhash[this.stw__tabi] = (short)hash;
        this.stw__tabi = (short)(this.stw__tabi + 1);
        if (this.stw__tabi >= 15000) {
            this.stw__tabi = 0;
        }
    }

    int stw__getref(int stri) {
        int strie = stri;
        int pos = stri;
        do {
            byte[] tb2;
            byte[] tb1;
            if (!Arrays.equals(tb1 = this.stw__tab[0][pos], this.s1Bytes) || !Arrays.equals(tb2 = this.stw__tab[1][pos], this.s2Bytes)) continue;
            int ref = this.stw__tabi - pos;
            if (ref <= 0) {
                ref += 15000;
            }
            return ref;
        } while ((pos = this.stw__tabnext[pos]) != strie);
        return -1;
    }

    void stw_reset() {
        this.stw__tabi = 0;
        Arrays.fill(this.stw__tabhash, (short)-1);
        Arrays.fill(this.stw__hashtab, (short)-1);
    }

    private int stw_hash(String s1, String s2) {
        int len = this.s1Bytes.length;
        if (this.s2Bytes != null) {
            len += this.s2Bytes.length;
        }
        if (len > 250) {
            return -1;
        }
        int hash = s1.hashCode();
        if (s2 != null) {
            hash ^= s2.hashCode();
        }
        return Math.abs(hash % 15000);
    }

    private int writeUnsignedNum(int number, OutputStream stream) throws IOException {
        int num = number;
        int cntBytes = 0;
        int part = num & 0x7F;
        if (part == num) {
            stream.write(part);
            return 1;
        }
        do {
            this.numberConversionBuf[cntBytes++] = (byte)(part | 0x80);
        } while ((part = (num >>= 7) & 0x7F) != num);
        this.numberConversionBuf[cntBytes++] = (byte)part;
        stream.write(this.numberConversionBuf, 0, cntBytes);
        return cntBytes;
    }

    private int writeSignedNum(long num, OutputStream stream) throws IOException {
        long u;
        int cntBytes = 0;
        if (num < 0L) {
            u = -num;
            u = (u << 1) - 1L;
        } else {
            u = num << 1;
        }
        int part = (int)(u & 0x7FL);
        if ((long)part == u) {
            stream.write(part);
            return 1;
        }
        do {
            this.numberConversionBuf[cntBytes++] = (byte)(part | 0x80);
        } while ((long)(part = (int)((u >>>= 7) & 0x7FL)) != u);
        this.numberConversionBuf[cntBytes++] = (byte)part;
        stream.write(this.numberConversionBuf, 0, cntBytes);
        return cntBytes;
    }

    static {
        try {
            for (String s : Arrays.asList("1", "1outer", "1inner", "type", "building", "source", "highway", "addr:housenumber", "addr:street", "name", "addr:city", "addr:postcode", "natural", "source:date", "addr:country", "landuse", "surface", "created_by", "power", "tiger:cfcc", "waterway", "tiger:county", "start_date", "tiger:reviewed", "wall", "amenity", "oneway", "ref:bag", "ref", "attribution", "tiger:name_base", "building:levels", "maxspeed", "barrier", "tiger:name_type", "height", "service", "source:addr", "tiger:tlid", "tiger:source", "lanes", "access", "addr:place", "tiger:zip_left", "tiger:upload_uuid", "layer", "tracktype", "ele", "tiger:separated", "tiger:zip_right", "yh:WIDTH", "place", "foot")) {
                wellKnownTagKeys.put(s, s.getBytes(StandardCharsets.UTF_8));
            }
            for (String s : Arrays.asList("yes", "no", "residential", "garage", "water", "tower", "footway", "Bing", "PGS", "private", "stream", "service", "house", "unclassified", "track", "traffic_signals", "restaurant", "entrance")) {
                wellKnownTagVals.put(s, s.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

