/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import uk.me.parabola.splitter.SplitFailedException;

public class SparseBitSet {
    private static final long MID_ID_MASK = 0x7FFFFFFL;
    private static final long TOP_ID_MASK = -134217728L;
    private static final int LOW_MASK = 63;
    private static final int TOP_ID_SHIFT = Long.numberOfTrailingZeros(-134217728L);
    private static final int MID_ID_SHIFT = Integer.numberOfTrailingZeros(-64);
    private Long2ObjectOpenHashMap<Int2LongOpenHashMap> topMap = new Long2ObjectOpenHashMap();
    private long bitCount;

    public void set(long key) {
        long topId = key >> TOP_ID_SHIFT;
        Int2LongOpenHashMap midMap = this.topMap.get(topId);
        if (midMap == null) {
            midMap = new Int2LongOpenHashMap();
            this.topMap.put(topId, midMap);
        }
        int midId = (int)((key & 0x7FFFFFFL) >> MID_ID_SHIFT);
        long chunk = midMap.get(midId);
        int bitPos = (int)(key & 0x3FL);
        long val = 1L << bitPos - 1;
        if (chunk != 0L) {
            if ((chunk & val) != 0L) {
                return;
            }
            val |= chunk;
        }
        midMap.put(midId, val);
        ++this.bitCount;
    }

    public void clear(long key) {
        long topId = key >> TOP_ID_SHIFT;
        Int2LongOpenHashMap midMap = this.topMap.get(topId);
        if (midMap == null) {
            return;
        }
        int midId = (int)((key & 0x7FFFFFFL) >> MID_ID_SHIFT);
        long chunk = midMap.get(midId);
        if (chunk == 0L) {
            return;
        }
        int bitPos = (int)(key & 0x3FL);
        long val = 1L << bitPos - 1;
        if ((chunk & val) == 0L) {
            return;
        }
        if ((chunk &= val ^ 0xFFFFFFFFFFFFFFFFL) == 0L) {
            midMap.remove(midId);
            if (midMap.isEmpty()) {
                this.topMap.remove(topId);
            }
        } else {
            midMap.put(midId, chunk);
        }
        --this.bitCount;
    }

    public boolean get(long key) {
        long topId = key >> TOP_ID_SHIFT;
        Int2LongOpenHashMap midMap = this.topMap.get(topId);
        if (midMap == null) {
            return false;
        }
        int midId = (int)((key & 0x7FFFFFFL) >> MID_ID_SHIFT);
        long chunk = midMap.get(midId);
        if (chunk == 0L) {
            return false;
        }
        int bitPos = (int)(key & 0x3FL);
        long val = 1L << bitPos - 1;
        return (chunk & val) != 0L;
    }

    public void clear() {
        this.topMap.clear();
        this.bitCount = 0L;
    }

    public int cardinality() {
        if (this.bitCount > Integer.MAX_VALUE) {
            throw new SplitFailedException("cardinality too high for int " + this.bitCount);
        }
        return (int)this.bitCount;
    }
}

