/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.RoundingUtils;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.solver.PolygonDesc;

class PolygonDescProcessor
extends AbstractMapProcessor {
    private Long2ObjectOpenHashMap<Node> nodes = new Long2ObjectOpenHashMap();
    private final List<PolygonDesc> polygonDescriptions = new ArrayList<PolygonDesc>();
    private final int shift;

    public PolygonDescProcessor(int resolution) {
        this.shift = 24 - resolution;
    }

    @Override
    public void processNode(Node n) {
        int lat = RoundingUtils.round(n.getMapLat(), this.shift);
        int lon = RoundingUtils.round(n.getMapLon(), this.shift);
        double roundedLat = Utils.toDegrees(lat);
        double roundedLon = Utils.toDegrees(lon);
        Node rNode = new Node();
        rNode.set(n.getId(), roundedLat, roundedLon);
        this.nodes.put(rNode.getId(), rNode);
    }

    @Override
    public void processWay(Way w) {
        int mapId;
        String name = w.getTag("name");
        if (name == null) {
            System.out.println("name missing, ignoring way " + w.getId());
            return;
        }
        String mapIdString = w.getTag("mapid");
        if (mapIdString == null) {
            System.out.println("mapid missing, ignoring way " + w.getId());
            return;
        }
        try {
            mapId = Integer.parseInt(mapIdString);
        }
        catch (NumberFormatException e) {
            System.out.println("invalid mapid in way " + w.getId());
            return;
        }
        Path2D.Double path = null;
        LongListIterator longListIterator = w.getRefs().iterator();
        while (longListIterator.hasNext()) {
            long ref = (Long)longListIterator.next();
            Node n = this.nodes.get(ref);
            if (n == null) continue;
            if (path == null) {
                path = new Path2D.Double();
                ((Path2D)path).moveTo(n.getMapLon(), n.getMapLat());
                continue;
            }
            ((Path2D)path).lineTo(n.getMapLon(), n.getMapLat());
        }
        PolygonDesc pd = new PolygonDesc(name, new Area(path), mapId);
        this.polygonDescriptions.add(pd);
    }

    @Override
    public boolean endMap() {
        this.nodes = null;
        System.out.println("found " + this.polygonDescriptions.size() + " named polygons");
        return true;
    }

    public List<PolygonDesc> getPolygons() {
        return this.polygonDescriptions;
    }
}

