/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.parser.ElementCounter;

public class O5mMapParser {
    private static final int NODE_DATASET = 16;
    private static final int WAY_DATASET = 17;
    private static final int REL_DATASET = 18;
    private static final int BBOX_DATASET = 219;
    private static final int TIMESTAMP_DATASET = 220;
    private static final int HEADER_DATASET = 224;
    private static final int EOD_FLAG = 254;
    private static final int RESET_FLAG = 255;
    private static final int STRING_TABLE_SIZE = 15000;
    private static final int MAX_STRING_PAIR_SIZE = 252;
    private static final String[] REL_REF_TYPES = new String[]{"node", "way", "relation", "?"};
    private static final double FACTOR = 1.0E-9;
    private final ElementCounter elemCounter = new ElementCounter();
    private final boolean skipTags;
    private final boolean skipNodes;
    private final boolean skipWays;
    private final boolean skipRels;
    private final FileChannel fileChannel;
    private static final int BUF_SIZE = 4096;
    private final ByteBuffer fileBuffer = ByteBuffer.allocate(4096);
    private long filePos;
    private long bufStart;
    private int bufSize = -1;
    private long nextFilePos;
    private final MapProcessor processor;
    private final byte[] cnvBuffer;
    private String[][] stringTable;
    private final String[] stringPair;
    private int currStringTablePos;
    private long[] firstPosInFile;
    private long[] skipArray;
    private long lastNodeId;
    private long lastWayId;
    private long lastRelId;
    private long[] lastRef;
    private long lastTs;
    private long lastChangeSet;
    private int lastLon;
    private int lastLat;

    public O5mMapParser(MapProcessor processor, FileChannel fc, long[] skipArray) {
        this.fileChannel = fc;
        this.processor = processor;
        this.skipArray = skipArray;
        this.skipTags = processor.skipTags();
        this.skipNodes = processor.skipNodes();
        this.skipWays = processor.skipWays();
        this.skipRels = processor.skipRels();
        this.cnvBuffer = new byte[4000];
        this.stringPair = new String[2];
        this.lastRef = new long[3];
        if (skipArray == null) {
            this.firstPosInFile = new long[256];
            Arrays.fill(this.firstPosInFile, -1L);
        }
        this.reset();
    }

    public void parse() throws IOException {
        int start = this.get() & 0xFF;
        if (start != 255) {
            throw new IOException("wrong header byte " + start);
        }
        if (this.skipArray != null && this.skipNodes) {
            this.filePos = this.skipWays ? this.skipArray[18] : this.skipArray[17];
        }
        if (this.filePos >= 0L) {
            this.readFile();
        }
    }

    private void readFile() throws IOException {
        boolean done = false;
        block3: while (!done) {
            long size = 0L;
            int fileType = this.get() & 0xFF;
            if (fileType >= 0 && fileType < 240) {
                if (this.skipArray == null && this.firstPosInFile[fileType] == -1L) {
                    this.firstPosInFile[fileType] = Math.max(0L, this.filePos - 1L);
                }
                size = this.readUnsignedNum64();
                this.nextFilePos = this.filePos + size;
                boolean doSkip = fileType == 16 && this.skipNodes || fileType == 17 && this.skipWays || fileType == 18 && this.skipRels;
                switch (fileType) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 219: 
                    case 220: 
                    case 224: {
                        if (!doSkip) break;
                        this.filePos = this.nextFilePos;
                        continue block3;
                    }
                }
            }
            if (fileType == 16) {
                this.readNode();
                continue;
            }
            if (fileType == 17) {
                this.readWay();
                continue;
            }
            if (fileType == 18) {
                this.readRel();
                continue;
            }
            if (fileType == 219) {
                this.readBBox();
                continue;
            }
            if (fileType == 220) {
                this.readFileTimestamp();
                continue;
            }
            if (fileType == 224) {
                this.readHeader();
                continue;
            }
            if (fileType == 254) {
                done = true;
                continue;
            }
            if (fileType == 255) {
                this.reset();
                continue;
            }
            if (fileType >= 240) continue;
            this.filePos = this.nextFilePos;
        }
    }

    private void readFileTimestamp() throws IOException {
        this.readSignedNum64();
    }

    private void readBBox() throws IOException {
        double leftf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double bottomf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double rightf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double topf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        assert (this.filePos == this.nextFilePos);
        System.out.println("Bounding box " + leftf + " " + bottomf + " " + rightf + " " + topf);
        Area area = new Area(Utils.toMapUnit(bottomf), Utils.toMapUnit(leftf), Utils.toMapUnit(topf), Utils.toMapUnit(rightf));
        if (!area.verify()) {
            throw new IllegalArgumentException("invalid bbox area in o5m file: " + area);
        }
        this.processor.boundTag(area);
    }

    private void readNode() throws IOException {
        int lat;
        int lon;
        Node node = new Node();
        this.lastNodeId += this.readSignedNum64();
        if (this.filePos == this.nextFilePos) {
            return;
        }
        int version = this.readVersionTsAuthor();
        node.setVersion(version);
        if (this.filePos == this.nextFilePos) {
            return;
        }
        this.lastLon = lon = this.readSignedNum32() + this.lastLon;
        this.lastLat = lat = this.readSignedNum32() + this.lastLat;
        double flon = (double)(100L * (long)lon) * 1.0E-9;
        double flat = (double)(100L * (long)lat) * 1.0E-9;
        assert (flat >= -90.0 && flat <= 90.0);
        assert (flon >= -180.0 && flon <= 180.0);
        node.set(this.lastNodeId, flat, flon);
        this.readTags(node);
        this.elemCounter.countNode(this.lastNodeId);
        this.processor.processNode(node);
    }

    private void readWay() throws IOException {
        this.lastWayId += this.readSignedNum64();
        if (this.filePos == this.nextFilePos) {
            return;
        }
        int version = this.readVersionTsAuthor();
        if (this.filePos == this.nextFilePos) {
            return;
        }
        Way way = new Way();
        way.setId(this.lastWayId);
        way.setVersion(version);
        long refSize = this.readUnsignedNum32();
        long stop = this.filePos + refSize;
        while (this.filePos < stop) {
            this.lastRef[0] = this.lastRef[0] + this.readSignedNum64();
            way.addRef(this.lastRef[0]);
        }
        this.readTags(way);
        this.elemCounter.countWay(this.lastWayId);
        this.processor.processWay(way);
    }

    private void readRel() throws IOException {
        this.lastRelId += this.readSignedNum64();
        if (this.filePos == this.nextFilePos) {
            return;
        }
        int version = this.readVersionTsAuthor();
        if (this.filePos == this.nextFilePos) {
            return;
        }
        Relation rel = new Relation();
        rel.setId(this.lastRelId);
        rel.setVersion(version);
        long refSize = this.readUnsignedNum32();
        long stop = this.filePos + refSize;
        while (this.filePos < stop) {
            int refType;
            long deltaRef = this.readSignedNum64();
            int n = refType = this.readRelRef();
            this.lastRef[n] = this.lastRef[n] + deltaRef;
            rel.addMember(this.stringPair[0], this.lastRef[refType], this.stringPair[1]);
        }
        this.readTags(rel);
        this.elemCounter.countRelation(this.lastRelId);
        this.processor.processRelation(rel);
    }

    private void readTags(Element elem) throws IOException {
        if (this.skipTags && this.skipRels) {
            this.filePos = this.nextFilePos;
            return;
        }
        while (this.filePos < this.nextFilePos) {
            this.readStringPair();
            if (this.skipTags) continue;
            elem.addTag(this.stringPair[0], this.stringPair[1]);
        }
        assert (this.filePos == this.nextFilePos);
    }

    private void storeStringPair() {
        this.stringTable[0][this.currStringTablePos] = this.stringPair[0];
        this.stringTable[1][this.currStringTablePos] = this.stringPair[1];
        ++this.currStringTablePos;
        if (this.currStringTablePos >= 15000) {
            this.currStringTablePos = 0;
        }
    }

    private void setStringRefPair(int ref) throws IOException {
        int pos = this.currStringTablePos - ref;
        if (pos < 0) {
            pos += 15000;
        }
        if (pos < 0 || pos >= 15000) {
            throw new IOException("invalid string table reference: " + ref);
        }
        this.stringPair[0] = this.stringTable[0][pos];
        this.stringPair[1] = this.stringTable[1][pos];
    }

    private int readVersionTsAuthor() throws IOException {
        int version = this.readUnsignedNum32();
        if (version != 0) {
            long ts;
            this.lastTs = ts = this.readSignedNum64() + this.lastTs;
            if (ts != 0L) {
                long changeSet;
                this.lastChangeSet = changeSet = (long)this.readSignedNum32() + this.lastChangeSet;
                this.readAuthor();
            }
        }
        return version;
    }

    private void readAuthor() throws IOException {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.filePos;
            long uidNum = this.readUnsignedNum64();
            if (uidNum == 0L) {
                this.stringPair[0] = "";
            } else {
                this.stringPair[0] = Long.toString(uidNum);
                this.get();
            }
            this.stringPair[1] = this.readString();
            if (this.filePos - toReadStart <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private int readRelRef() throws IOException {
        int refType = -1;
        long toReadStart = this.filePos;
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            refType = this.get() - 48;
            if (refType < 0 || refType > 2) {
                refType = 3;
            }
            this.stringPair[0] = REL_REF_TYPES[refType];
            this.stringPair[1] = this.readString();
            if (this.filePos - toReadStart <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
            char c = this.stringPair[0].charAt(0);
            switch (c) {
                case 'n': {
                    refType = 0;
                    break;
                }
                case 'w': {
                    refType = 1;
                    break;
                }
                case 'r': {
                    refType = 2;
                    break;
                }
                default: {
                    refType = 3;
                }
            }
        }
        return refType;
    }

    private void readStringPair() throws IOException {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.filePos;
            int cnt = 0;
            while (cnt < 2) {
                this.stringPair[cnt++] = this.readString();
            }
            if (this.filePos - toReadStart <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    String readString() throws IOException {
        int length = 0;
        byte b;
        while ((b = this.get()) != 0) {
            this.cnvBuffer[length++] = b;
        }
        return new String(this.cnvBuffer, 0, length, StandardCharsets.UTF_8);
    }

    private void reset() {
        this.lastNodeId = 0L;
        this.lastWayId = 0L;
        this.lastRelId = 0L;
        this.lastRef[0] = 0L;
        this.lastRef[1] = 0L;
        this.lastRef[2] = 0L;
        this.lastTs = 0L;
        this.lastChangeSet = 0L;
        this.lastLon = 0;
        this.lastLat = 0;
        this.stringTable = new String[2][15000];
        this.currStringTablePos = 0;
    }

    private void readHeader() throws IOException {
        byte[] header = new byte[4];
        for (int i = 0; i < header.length; ++i) {
            header[i] = this.get();
        }
        if (header[0] != 111 || header[1] != 53 || header[2] != 99 && header[2] != 109 || header[3] != 50) {
            throw new IOException("unsupported header");
        }
    }

    private int readSignedNum32() throws IOException {
        int b;
        int result = b = this.get();
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1 - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7E) >> 1;
        int fac = 64;
        while (true) {
            byte by = this.get();
            b = by;
            if ((by & 0x80) == 0) break;
            result += fac * (b & 0x7F);
            fac <<= 7;
        }
        result += fac * b;
        if (sign == 1) {
            return -1 - result;
        }
        return result;
    }

    private long readSignedNum64() throws IOException {
        byte b = this.get();
        long result = b;
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1L - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7EL) >> 1;
        long fac = 64L;
        while (((b = this.get()) & 0x80) != 0) {
            result += fac * (long)(b & 0x7F);
            fac <<= 7;
        }
        result += fac * (long)b;
        if (sign == 1) {
            return -1L - result;
        }
        return result;
    }

    private long readUnsignedNum64() throws IOException {
        byte b = this.get();
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        long fac = 128L;
        while (((b = this.get()) & 0x80) != 0) {
            result += fac * (long)(b & 0x7F);
            fac <<= 7;
        }
        return result += fac * (long)b;
    }

    private int readUnsignedNum32() throws IOException {
        int b;
        int result = b = this.get();
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7F;
        long fac = 128L;
        while (true) {
            byte by = this.get();
            b = by;
            if ((by & 0x80) == 0) break;
            result = (int)((long)result + fac * (long)(b & 0x7F));
            fac <<= 7;
        }
        result = (int)((long)result + fac * (long)b);
        return result;
    }

    public long[] getNextSkipArray() {
        return this.firstPosInFile;
    }

    private byte get() throws IOException {
        this.fillBuffer();
        int pos = (int)(this.filePos - this.bufStart);
        if (pos < 0 || pos >= this.bufSize) {
            throw new IOException("no data in file buffer, pos=" + pos);
        }
        ++this.filePos;
        return this.fileBuffer.get(pos);
    }

    private void fillBuffer() throws IOException {
        if (this.filePos >= this.bufStart + (long)this.bufSize) {
            this.bufStart = this.filePos & 0xFFFFFFFFFFFFF000L;
            this.fileChannel.position(this.bufStart);
            this.fileBuffer.clear();
            this.bufSize = this.fileChannel.read(this.fileBuffer);
        }
    }
}

