/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.geo;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.geo.City;
import uk.me.parabola.splitter.geo.CityFinder;

public class DefaultCityFinder
implements CityFinder {
    private final int[] lats;
    private final int[] lons;
    private final City[] citiesByLat;

    public DefaultCityFinder(List<City> cities) {
        this.lats = new int[cities.size()];
        this.lons = new int[cities.size()];
        this.citiesByLat = new City[cities.size()];
        cities.sort((c1, c2) -> Integer.compare(c1.getLat(), c2.getLat()));
        int i = 0;
        for (City city : cities) {
            this.lats[i] = city.getLat();
            this.lons[i] = city.getLon();
            this.citiesByLat[i++] = city;
        }
    }

    @Override
    public Set<City> findCities(Area area) {
        return this.findCities(area.getMinLat(), area.getMinLong(), area.getMaxLat(), area.getMaxLong());
    }

    @Override
    public Set<City> findCities(int minLat, int minLon, int maxLat, int maxLon) {
        int maxLatIndex;
        int minLatIndex = DefaultCityFinder.findMinIndex(this.lats, minLat);
        if (minLatIndex > (maxLatIndex = DefaultCityFinder.findMaxIndex(this.lats, maxLat))) {
            return Collections.emptySet();
        }
        HashSet<City> hits = new HashSet<City>(100);
        for (int i = minLatIndex; i <= maxLatIndex; ++i) {
            City city = this.citiesByLat[i];
            if (city.getLon() < minLon || city.getLon() > maxLon) continue;
            hits.add(city);
        }
        return hits;
    }

    private static int findMinIndex(int[] data, int value) {
        int result = Arrays.binarySearch(data, value);
        if (result < 0) {
            return -1 - result;
        }
        while (result > 0 && data[result - 1] == value) {
            --result;
        }
        return result;
    }

    private static int findMaxIndex(int[] data, int value) {
        int result = Arrays.binarySearch(data, value);
        if (result < 0) {
            return -2 - result;
        }
        while (result < data.length - 2 && data[result + 1] == value) {
            ++result;
        }
        return result;
    }
}

