/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.geo;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import uk.me.parabola.splitter.Convert;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.geo.City;

public class CityLoader {
    private static final Pattern TAB_DELIMTED_SPLIT_PATTERN = Pattern.compile("\\t");
    private static final int GEONAME_ID_INDEX = 0;
    private static final int NAME_INDEX = 1;
    private static final int ASCII_NAME_INDEX = 2;
    private static final int COUNTRY_CODE_INDEX = 8;
    private static final int LAT_INDEX = 4;
    private static final int LON_INDEX = 5;
    private static final int POPULATION_INDEX = 14;
    private final boolean useAsciiNames;

    public CityLoader(boolean useAsciiNames) {
        this.useAsciiNames = useAsciiNames;
    }

    public List<City> load(String geoNamesFile) {
        List<City> result = null;
        try (BufferedReader r = new BufferedReader(Utils.openFile(geoNamesFile, true));){
            result = this.load(r);
        }
        catch (IOException ignore) {
            System.out.println("Warning: Could not read geonames file " + geoNamesFile + ", processing continues");
        }
        return result;
    }

    public List<City> load(BufferedReader reader) throws IOException {
        String line;
        ArrayList<City> cities = new ArrayList<City>(1000);
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNumber;
            try {
                String[] split = TAB_DELIMTED_SPLIT_PATTERN.split(line, 16);
                int geoNameId = Integer.parseInt(split[0]);
                String name = this.useAsciiNames ? new String(split[2].toCharArray()) : new String(split[1].toCharArray());
                String countryCode = new String(split[8].toCharArray()).intern();
                int population = Integer.parseInt(split[14]);
                int lat = Utils.toMapUnit(Convert.parseDouble(split[4]));
                int lon = Utils.toMapUnit(Convert.parseDouble(split[5]));
                cities.add(new City(geoNameId, countryCode, name, lat, lon, population));
            }
            catch (Exception e) {
                System.err.format("Unable to parse GeoNames data at line %d%nReason:%s%nData: %s%n", lineNumber, e.toString(), line);
            }
        }
        return cities;
    }
}

