/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.args;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.splitter.StopNoErrorException;
import uk.me.parabola.splitter.Version;
import uk.me.parabola.splitter.args.Option;
import uk.me.parabola.splitter.args.Param;
import uk.me.parabola.splitter.args.ParamConverter;
import uk.me.parabola.splitter.args.ReflectionUtils;

public class ParamParser {
    private final ParamConverter converter = new ParamConverter();
    private final Map<String, Param> paramMap = new TreeMap<String, Param>();
    private final Map<String, Object> convertedParamMap = new TreeMap<String, Object>();
    private final List<String> additionalParams = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();
    private boolean wantHelp;
    private boolean wantVersion;
    private int maxParamLength;

    public <P> P parse(Class<P> paramInterface, String ... args) {
        if (!paramInterface.isInterface()) {
            throw new IllegalArgumentException(paramInterface + " must be an interface");
        }
        return this.createProxy(paramInterface, args);
    }

    public Map<String, Param> getValidParams() {
        return this.paramMap;
    }

    public Map<String, Object> getConvertedParams() {
        return this.convertedParamMap;
    }

    public List<String> getAdditionalParams() {
        return this.additionalParams;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private <P> P createProxy(Class<P> paramInterface, String ... args) {
        String name;
        Option option;
        HashMap<String, MethodParamPair> params = new HashMap<String, MethodParamPair>();
        this.paramMap.clear();
        this.convertedParamMap.clear();
        this.wantHelp = false;
        this.wantVersion = false;
        for (Method method : paramInterface.getDeclaredMethods()) {
            option = ReflectionUtils.getOptionAnnotation(method);
            name = ParamParser.getParameterName(method, option);
            if (name.length() > this.maxParamLength) {
                this.maxParamLength = name.length();
            }
            String description = option.description();
            String defaultValue = option.defaultValue();
            if (defaultValue.equals("**OPTIONAL**")) {
                defaultValue = null;
            }
            Class<?> returnType = ReflectionUtils.getBoxedClass(method.getReturnType());
            Param param = new Param(name, description, defaultValue, returnType);
            this.paramMap.put(name, param);
            MethodParamPair pair = new MethodParamPair(method, param);
            params.put(name, pair);
        }
        Map<Method, Object> valuesMap = this.convert(params, args);
        for (Map.Entry<Method, Object> entry : valuesMap.entrySet()) {
            Method method;
            method = entry.getKey();
            option = ReflectionUtils.getOptionAnnotation(method);
            name = ParamParser.getParameterName(method, option);
            this.convertedParamMap.put(name, entry.getValue());
        }
        if (this.wantHelp) {
            this.displayUsage();
            throw new StopNoErrorException(null);
        }
        if (this.wantVersion) {
            System.err.println("splitter " + Version.VERSION + " compiled " + Version.TIMESTAMP);
            throw new StopNoErrorException(null);
        }
        ParamInvocationHandler invocationHandler = new ParamInvocationHandler(valuesMap);
        return (P)Proxy.newProxyInstance(paramInterface.getClassLoader(), new Class[]{paramInterface}, (InvocationHandler)invocationHandler);
    }

    private Map<Method, Object> convert(Map<String, MethodParamPair> paramMap, String[] args) {
        HashMap<Method, Object> result = new HashMap<Method, Object>(10);
        for (MethodParamPair pair : paramMap.values()) {
            Method method = pair.getMethod();
            Param param = pair.getParam();
            Object value = this.converter.convert(param, param.getDefaultValue());
            if (value == null && method.getReturnType().isPrimitive()) {
                result.put(method, this.converter.getPrimitiveDefault(method.getReturnType()));
                continue;
            }
            result.put(method, value);
        }
        HashMap<String, String> parsedArgs = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.startsWith("--")) {
                MethodParamPair pair;
                String value;
                String name;
                int j = arg.indexOf(61);
                if (j > 0) {
                    name = arg.substring(2, j);
                    value = arg.substring(j + 1);
                } else {
                    name = arg.substring(2);
                    value = null;
                }
                String testVal = value == null ? "no val" : value;
                String oldVal = parsedArgs.put(name, testVal);
                if (oldVal != null && !oldVal.equals(testVal)) {
                    System.err.println("Warning: repeated paramter overwrites previous value: --" + name + (value == null ? "" : "=" + value));
                }
                if ((pair = paramMap.get(name)) != null) {
                    if (pair.getParam().getReturnType() == Boolean.class && value == null) {
                        result.put(pair.getMethod(), Boolean.TRUE);
                        continue;
                    }
                    try {
                        Object convertedVal = this.converter.convert(pair.getParam(), value);
                        result.put(pair.getMethod(), convertedVal);
                    }
                    catch (Exception e) {
                        this.errors.add("Unable to parse " + arg + ". Reason: " + e.getMessage());
                    }
                    continue;
                }
                if ("help".equals(name)) {
                    this.wantHelp = true;
                    continue;
                }
                if ("version".equals(name)) {
                    this.wantVersion = true;
                    continue;
                }
                this.errors.add("Parameter " + arg + " is not recognised");
                continue;
            }
            this.additionalParams.add(arg);
        }
        return result;
    }

    public void displayUsage() {
        System.out.println("Usage: java [JAVA_OPTIONS] -jar splitter.jar [OPTIONS] input_file (*.osm or *.pbf or *.o5m)");
        System.out.println("Options:");
        String lastName = null;
        int leftColWidth = this.maxParamLength + 5;
        for (Param param : this.paramMap.values()) {
            String[] descWords;
            String ln;
            String desc = param.getDescription();
            if (param.getDefaultValue() != null) {
                desc = desc + " Default is " + param.getDefaultValue() + ".";
            }
            if ("help".compareTo(param.getName()) < 0 && lastName != null && "help".compareTo(lastName) >= 0) {
                ln = ParamParser.padRight(" --help", leftColWidth) + "Print this help.";
                System.out.println(ln);
            }
            if ("version".compareTo(param.getName()) < 0 && lastName != null && "version".compareTo(lastName) >= 0) {
                ln = ParamParser.padRight(" --version", leftColWidth) + "Just write program version and build timestamp.";
                System.out.println(ln);
            }
            ln = ParamParser.padRight(" --" + param.getName(), leftColWidth);
            for (String word : descWords = desc.split(" ")) {
                if (ln.length() + word.length() >= 78) {
                    System.out.println(ln);
                    ln = ParamParser.padRight("", leftColWidth);
                }
                ln = ln + word + " ";
            }
            System.out.println(ln);
            lastName = param.getName();
        }
    }

    private static String padRight(String s, int wantedLen) {
        return String.format("%1$-" + wantedLen + "s", s);
    }

    private static String getParameterName(Method method, Option option) {
        return option.name().length() == 0 ? ReflectionUtils.getParamName(method) : option.name();
    }

    private static class MethodParamPair {
        private final Method method;
        private final Param param;

        private MethodParamPair(Method method, Param param) {
            this.method = method;
            this.param = param;
        }

        public Method getMethod() {
            return this.method;
        }

        public Param getParam() {
            return this.param;
        }
    }

    private static class ParamInvocationHandler
    implements InvocationHandler {
        private final Map<Method, Object> valuesMap;

        private ParamInvocationHandler(Map<Method, Object> valuesMap) {
            this.valuesMap = valuesMap;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.valuesMap.get(method);
        }
    }
}

