/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.BackgroundInputStream;

public class Utils {
    private static final NumberFormat FORMATTER = NumberFormat.getIntegerInstance();
    public static final int MIN_LAT_MAP_UNITS = Utils.toMapUnit(-90.0);
    public static final int MAX_LAT_MAP_UNITS = Utils.toMapUnit(90.0);
    public static final int MIN_LON_MAP_UNITS = Utils.toMapUnit(-180.0);
    public static final int MAX_LON_MAP_UNITS = Utils.toMapUnit(180.0);

    private Utils() {
    }

    public static String format(int number) {
        return FORMATTER.format(number);
    }

    public static String format(long number) {
        return FORMATTER.format(number);
    }

    public static double toDegrees(int val) {
        return 360.0 * (double)val / 1.6777216E7;
    }

    public static int toMapUnit(double l) {
        double delta = 1.0728836059570312E-5;
        if (l > 0.0) {
            return (int)((l + delta) * 1.6777216E7 / 360.0);
        }
        return (int)((l - delta) * 1.6777216E7 / 360.0);
    }

    public static Reader openFile(String name, boolean backgroundReader) throws IOException {
        InputStream is = new BufferedInputStream(new FileInputStream(name), 8192);
        if (name.endsWith(".gz")) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (IOException e) {
                throw new IOException("Could not read " + name + " as a gz compressed file", e);
            }
        } else if (name.endsWith(".bz2")) {
            try {
                ((InputStream)is).read();
                ((InputStream)is).read();
                is = new CBZip2InputStream(is);
            }
            catch (IOException e) {
                throw new IOException("Could not read " + name + " as a bz2 compressed file", e);
            }
        } else if (name.endsWith(".zip")) {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(is);
            name = new File(name).getName();
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith(name.substring(0, name.length() - 4))) continue;
                is = zis;
                break;
            }
            if (is != zis) {
                zis.close();
                throw new IOException("Unable to find a file inside " + name + " that starts with " + name.substring(0, name.length() - 4));
            }
        }
        if (backgroundReader) {
            is = new BackgroundInputStream(is);
        }
        return new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    public static Rectangle area2Rectangle(Area area, int overlap) {
        return new Rectangle(area.getMinLong() - overlap, area.getMinLat() - overlap, area.getWidth() + 2 * overlap, area.getHeight() + 2 * overlap);
    }

    public static List<List<Point>> areaToShapes(java.awt.geom.Area area) {
        ArrayList<List<Point>> outputs = new ArrayList<List<Point>>();
        float[] res = new float[6];
        PathIterator pit = area.getPathIterator(null);
        ArrayList<Point> points = null;
        int iPrevLat = Integer.MIN_VALUE;
        int iPrevLong = Integer.MIN_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            float fLat = res[1];
            float fLon = res[0];
            int iLat = Math.round(fLat);
            int iLon = Math.round(fLon);
            switch (type) {
                case 1: {
                    if (iPrevLat != iLat || iPrevLong != iLon) {
                        points.add(new Point(iLon, iLat));
                    }
                    iPrevLat = iLat;
                    iPrevLong = iLon;
                    break;
                }
                case 0: 
                case 4: {
                    if (type == 0 && points != null || type == 4) {
                        if (points.size() > 2 && !((Point)points.get(0)).equals(points.get(points.size() - 1))) {
                            points.add((Point)points.get(0));
                        }
                        if (points.size() > 3) {
                            outputs.add(points);
                        }
                    }
                    if (type == 0) {
                        points = new ArrayList<Point>();
                        points.add(new Point(iLon, iLat));
                        iPrevLat = iLat;
                        iPrevLong = iLon;
                        break;
                    }
                    points = null;
                    iPrevLat = Integer.MIN_VALUE;
                    iPrevLong = Integer.MIN_VALUE;
                    break;
                }
                default: {
                    System.out.println("Unsupported path iterator type " + type + ". This is an internal splitter error.");
                }
            }
            pit.next();
        }
        return outputs;
    }

    public static java.awt.geom.Area shapeToArea(List<Point> shape) {
        Polygon polygon = new Polygon();
        for (Point point : shape) {
            polygon.addPoint(point.x, point.y);
        }
        return new java.awt.geom.Area(polygon);
    }

    public static java.awt.geom.Area AreaDegreesToMapUnit(java.awt.geom.Area area) {
        if (area == null) {
            return null;
        }
        double[] res = new double[6];
        Path2D.Double path = new Path2D.Double();
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double fLat = res[1];
            double fLon = res[0];
            int lat = Utils.toMapUnit(fLat);
            int lon = Utils.toMapUnit(fLon);
            switch (type) {
                case 1: {
                    ((Path2D)path).lineTo(lon, lat);
                    break;
                }
                case 0: {
                    ((Path2D)path).moveTo(lon, lat);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    System.out.println("Unsupported path iterator type " + type + ". This is an internal splitter error.");
                }
            }
            pit.next();
        }
        return new java.awt.geom.Area(path);
    }

    public static boolean clockwise(List<Point> points) {
        if (points.size() < 3 || !points.get(0).equals(points.get(points.size() - 1))) {
            return false;
        }
        long area = 0L;
        Point p1 = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Point p2 = points.get(i);
            area += (long)p1.x * (long)p2.y - (long)p2.x * (long)p1.y;
            p1 = p2;
        }
        return area <= 0L;
    }

    public static void printMem() {
        long maxMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        long usedMem = totalMem - freeMem;
        System.out.println("  JVM Memory Info: Current " + totalMem + "MB (" + usedMem + "MB used, " + freeMem + "MB free) Max " + maxMem + "MB");
    }
}

