/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.AreaDictionary;
import uk.me.parabola.splitter.AreaGridResult;
import uk.me.parabola.splitter.AreaIndex;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.DataStorer;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.args.SplitterParams;
import uk.me.parabola.splitter.tools.SparseLong2IntMap;

class ProblemListProcessor
extends AbstractMapProcessor {
    private static final int PHASE1_NODES_AND_WAYS = 1;
    private static final int PHASE2_RELS_ONLY = 2;
    private final SparseLong2IntMap coords;
    private final SparseLong2IntMap ways;
    private final AreaDictionary areaDictionary;
    private final DataStorer dataStorer;
    private final LongArrayList problemWays = new LongArrayList();
    private final LongArrayList problemRels = new LongArrayList();
    private final AreaSet areaSet = new AreaSet();
    private int phase = 1;
    private long countCoords = 0L;
    private final int areaOffset;
    private final int lastAreaOffset;
    private boolean isFirstPass;
    private boolean isLastPass;
    private AreaIndex areaIndex;
    private final HashSet<String> wantedBoundaryAdminLevels = new HashSet();
    private final HashSet<String> wantedBoundaryTagValues;
    private final HashSet<String> wantedRouteTagValues;
    private static final HashSet<String> unwantedBoundaryTagValues = new HashSet<String>(Arrays.asList("administrative", "postal_code", "political"));

    ProblemListProcessor(DataStorer dataStorer, int areaOffset, int numAreasThisPass, SplitterParams mainOptions) {
        this.dataStorer = dataStorer;
        this.areaDictionary = dataStorer.getAreaDictionary();
        if (dataStorer.getUsedWays() == null) {
            this.ways = new SparseLong2IntMap("way");
            this.ways.defaultReturnValue(Short.MIN_VALUE);
            dataStorer.setUsedWays(this.ways);
        } else {
            this.ways = dataStorer.getUsedWays();
        }
        this.areaIndex = dataStorer.getGrid();
        this.coords = new SparseLong2IntMap("coord");
        this.coords.defaultReturnValue(Short.MIN_VALUE);
        this.isFirstPass = areaOffset == 0;
        this.areaOffset = areaOffset;
        this.lastAreaOffset = areaOffset + numAreasThisPass - 1;
        this.isLastPass = areaOffset + numAreasThisPass == dataStorer.getNumOfAreas();
        String boundaryTagsParm = mainOptions.getBoundaryTags();
        if ("use-exclude-list".equals(boundaryTagsParm)) {
            this.wantedBoundaryTagValues = null;
        } else {
            String[] boundaryTags = boundaryTagsParm.split(Pattern.quote(","));
            this.wantedBoundaryTagValues = new HashSet<String>(Arrays.asList(boundaryTags));
        }
        this.setWantedAdminLevel(mainOptions.getWantedAdminLevel());
        String routeRelationValuesParm = mainOptions.getRouteRelValues();
        if (routeRelationValuesParm.isEmpty()) {
            this.wantedRouteTagValues = null;
        } else {
            String[] routeValues = routeRelationValuesParm.split(Pattern.quote(","));
            this.wantedRouteTagValues = new HashSet<String>(Arrays.asList(routeValues));
        }
    }

    public void setWantedAdminLevel(int adminLevel) {
        int max = 11;
        int min = Math.max(2, adminLevel);
        this.wantedBoundaryAdminLevels.clear();
        for (int i = min; i <= max; ++i) {
            this.wantedBoundaryAdminLevels.add(Integer.toString(i));
        }
    }

    @Override
    public boolean skipTags() {
        return this.phase == 1;
    }

    @Override
    public boolean skipNodes() {
        return this.phase == 2;
    }

    @Override
    public boolean skipWays() {
        return this.phase == 2;
    }

    @Override
    public boolean skipRels() {
        return this.phase != 2;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void processNode(Node node) {
        if (this.phase == 2) {
            return;
        }
        int countAreas = 0;
        int lastUsedArea = Short.MIN_VALUE;
        AreaGridResult areaCandidates = this.areaIndex.get(node);
        if (areaCandidates == null) {
            return;
        }
        this.areaSet.clear();
        for (int n : areaCandidates.set) {
            if (n < this.areaOffset || n > this.lastAreaOffset || areaCandidates.testNeeded && !this.areaDictionary.getArea(n).contains(node)) continue;
            this.areaSet.set(n);
            ++countAreas;
            lastUsedArea = n;
        }
        if (countAreas > 0) {
            int areaIdx = countAreas > 1 ? this.areaDictionary.translate(this.areaSet) : AreaDictionary.translate(lastUsedArea);
            this.coords.put(node.getId(), areaIdx);
            ++this.countCoords;
            if (this.countCoords % 10000000L == 0L) {
                System.out.println("coord MAP occupancy: " + Utils.format(this.countCoords) + ", number of area dictionary entries: " + this.areaDictionary.size());
            }
        }
    }

    @Override
    public void processWay(Way way) {
        int wayAreaIdx;
        if (this.phase == 2) {
            return;
        }
        boolean maybeChanged = false;
        int oldclIndex = Short.MIN_VALUE;
        this.areaSet.clear();
        LongListIterator longListIterator = way.getRefs().iterator();
        while (longListIterator.hasNext()) {
            long id = (Long)longListIterator.next();
            int clIdx = this.coords.get(id);
            if (clIdx == Short.MIN_VALUE || oldclIndex == clIdx) continue;
            this.areaSet.or(this.areaDictionary.getSet(clIdx));
            oldclIndex = clIdx;
            maybeChanged = true;
        }
        if ((!this.isFirstPass && maybeChanged || this.isLastPass && !this.isFirstPass) && (wayAreaIdx = this.ways.get(way.getId())) != Short.MIN_VALUE) {
            this.areaSet.or(this.areaDictionary.getSet(wayAreaIdx));
        }
        if (this.isLastPass && ProblemListProcessor.checkIfMultipleAreas(this.areaSet)) {
            this.problemWays.add(way.getId());
        }
        if (maybeChanged && !this.areaSet.isEmpty()) {
            this.ways.put(way.getId(), this.areaDictionary.translate(this.areaSet));
        }
    }

    @Override
    public void processRelation(Relation rel) {
        Integer relAreaIdx;
        if (this.phase == 1) {
            return;
        }
        boolean useThis = false;
        boolean isMPRelType = false;
        boolean hasBoundaryTag = false;
        boolean isWantedBoundary = this.wantedBoundaryTagValues == null;
        boolean isRouteRelType = false;
        boolean isWantedRoute = this.wantedRouteTagValues != null;
        Iterator<Element.Tag> tags = rel.tagsIterator();
        String admin_level = null;
        while (tags.hasNext()) {
            Element.Tag t = tags.next();
            if ("type".equals(t.key)) {
                if ("restriction".equals(t.value) || "through_route".equals(t.value) || t.value.startsWith("restriction:")) {
                    useThis = true;
                } else if ("multipolygon".equals(t.value) || "boundary".equals(t.value)) {
                    isMPRelType = true;
                } else if ("route".equals(t.value)) {
                    isRouteRelType = true;
                } else if ("associatedStreet".equals(t.value) || "street".equals(t.value)) {
                    useThis = true;
                }
            } else if ("boundary".equals(t.key)) {
                hasBoundaryTag = true;
                if (this.wantedBoundaryTagValues != null) {
                    if (this.wantedBoundaryTagValues.contains(t.value)) {
                        isWantedBoundary = true;
                    }
                } else if (unwantedBoundaryTagValues.contains(t.value)) {
                    isWantedBoundary = false;
                }
            } else if ("admin_level".equals(t.key)) {
                admin_level = t.value;
            }
            if (this.wantedRouteTagValues != null && "route".equals(t.key) && this.wantedRouteTagValues.contains(t.value)) {
                isWantedRoute = true;
            }
            if (!useThis) continue;
            break;
        }
        if (isMPRelType && (isWantedBoundary || !hasBoundaryTag)) {
            useThis = true;
        } else if (isMPRelType && hasBoundaryTag && admin_level != null) {
            if (this.wantedBoundaryAdminLevels.contains(admin_level)) {
                useThis = true;
            }
        } else if (isRouteRelType && isWantedRoute) {
            useThis = true;
        }
        if (!useThis) {
            return;
        }
        this.areaSet.clear();
        if (!this.isFirstPass && (relAreaIdx = this.dataStorer.getUsedRels().get(rel.getId())) != null) {
            this.areaSet.or(this.areaDictionary.getSet(relAreaIdx));
        }
        int oldclIndex = Short.MIN_VALUE;
        int oldwlIndex = Short.MIN_VALUE;
        for (Relation.Member mem : rel.getMembers()) {
            int wlIdx;
            long id = mem.getRef();
            if ("node".equals(mem.getType())) {
                int clIdx = this.coords.get(id);
                if (clIdx == Short.MIN_VALUE) continue;
                if (oldclIndex != clIdx) {
                    this.areaSet.or(this.areaDictionary.getSet(clIdx));
                }
                oldclIndex = clIdx;
                continue;
            }
            if (!"way".equals(mem.getType()) || (wlIdx = this.ways.get(id)) == Short.MIN_VALUE) continue;
            if (oldwlIndex != wlIdx) {
                this.areaSet.or(this.areaDictionary.getSet(wlIdx));
            }
            oldwlIndex = wlIdx;
        }
        if (this.areaSet.isEmpty()) {
            return;
        }
        if (this.isLastPass) {
            if (ProblemListProcessor.checkIfMultipleAreas(this.areaSet)) {
                this.problemRels.add(rel.getId());
            } else {
                this.dataStorer.storeRelationAreas(rel.getId(), this.areaSet);
            }
            return;
        }
        relAreaIdx = this.areaDictionary.translate(this.areaSet);
        this.dataStorer.getUsedRels().put(rel.getId(), relAreaIdx);
    }

    @Override
    public boolean endMap() {
        if (this.phase == 1) {
            ++this.phase;
            return false;
        }
        this.coords.stats(0);
        this.ways.stats(0);
        if (this.isLastPass) {
            System.out.println("");
            System.out.println("  Number of stored area combis for nodes: " + Utils.format(this.coords.size()));
            System.out.println("  Number of stored area combis for ways: " + Utils.format(this.dataStorer.getUsedWays().size()));
            System.out.println("  Number of stored Integers for rels: " + Utils.format(this.dataStorer.getUsedRels().size()));
            System.out.println("  Number of stored combis in dictionary: " + Utils.format(this.areaDictionary.size()));
            System.out.println("  Number of detected problem ways: " + Utils.format(this.problemWays.size()));
            System.out.println("  Number of detected problem rels: " + Utils.format(this.problemRels.size()));
            Utils.printMem();
            System.out.println("");
            this.dataStorer.getUsedWays().clear();
            this.dataStorer.getUsedRels().clear();
        }
        return true;
    }

    static boolean checkIfMultipleAreas(AreaSet areaCombis) {
        return areaCombis.cardinality() > 1;
    }

    public LongArrayList getProblemWays() {
        return this.problemWays;
    }

    public LongArrayList getProblemRels() {
        return this.problemRels;
    }
}

