/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Utils;

public class Node
extends Element {
    private double lat;
    private double lon;
    private int mapLat;
    private int mapLon;

    public void set(long id, double lat, double lon) {
        this.setId(id);
        this.lat = lat;
        this.lon = lon;
        this.mapLat = Utils.toMapUnit(lat);
        this.mapLon = Utils.toMapUnit(lon);
        if (this.mapLat < Utils.MIN_LAT_MAP_UNITS || this.mapLat > Utils.MAX_LAT_MAP_UNITS) {
            throw new IllegalArgumentException("invalid lattitude value " + lat);
        }
        if (this.mapLon < Utils.MIN_LON_MAP_UNITS || this.mapLon > Utils.MAX_LON_MAP_UNITS) {
            throw new IllegalArgumentException("invalid longitude value " + lon);
        }
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public int getMapLat() {
        return this.mapLat;
    }

    public int getMapLon() {
        return this.mapLon;
    }
}

