/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.AreaDictionary;
import uk.me.parabola.splitter.AreaGrid;
import uk.me.parabola.splitter.AreaIndex;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.tools.Long2IntClosedMapFunction;
import uk.me.parabola.splitter.tools.OSMId2ObjectMap;
import uk.me.parabola.splitter.tools.SparseLong2IntMap;
import uk.me.parabola.splitter.writer.OSMWriter;

public class DataStorer {
    public static final int NODE_TYPE = 0;
    public static final int WAY_TYPE = 1;
    public static final int REL_TYPE = 2;
    private final int numOfAreas;
    private final Long2IntClosedMapFunction[] maps = new Long2IntClosedMapFunction[3];
    private final AreaDictionary areaDictionary;
    private final AreaIndex areaIndex;
    private SparseLong2IntMap usedWays = null;
    private final OSMId2ObjectMap<Integer> usedRels = new OSMId2ObjectMap();
    private boolean idsAreNotSorted;
    private OSMWriter[] writers;
    private final Long2ObjectOpenHashMap<Integer> oneDistinctAreaOnlyRels = new Long2ObjectOpenHashMap();
    private final OSMId2ObjectMap<Integer> oneTileOnlyRels = new OSMId2ObjectMap();

    DataStorer(List<Area> areas, int overlapAmount) {
        this.numOfAreas = areas.size();
        this.areaDictionary = new AreaDictionary(areas, overlapAmount);
        this.areaIndex = new AreaGrid(this.areaDictionary);
    }

    public int getNumOfAreas() {
        return this.numOfAreas;
    }

    public AreaDictionary getAreaDictionary() {
        return this.areaDictionary;
    }

    public Area getArea(int idx) {
        return this.areaDictionary.getArea(idx);
    }

    public Area getExtendedArea(int idx) {
        return this.areaDictionary.getExtendedArea(idx);
    }

    public void setWriters(OSMWriter[] writers) {
        this.writers = writers;
    }

    public void setWriterMap(int type, Long2IntClosedMapFunction nodeWriterMap) {
        this.maps[type] = nodeWriterMap;
    }

    public Long2IntClosedMapFunction getWriterMap(int type) {
        return this.maps[type];
    }

    public AreaIndex getGrid() {
        return this.areaIndex;
    }

    public SparseLong2IntMap getUsedWays() {
        return this.usedWays;
    }

    public OSMId2ObjectMap<Integer> getUsedRels() {
        return this.usedRels;
    }

    public void setUsedWays(SparseLong2IntMap ways) {
        this.usedWays = ways;
    }

    public boolean isIdsAreNotSorted() {
        return this.idsAreNotSorted;
    }

    public void setIdsAreNotSorted(boolean idsAreNotSorted) {
        this.idsAreNotSorted = idsAreNotSorted;
    }

    public void restartWriterMaps() {
        for (Long2IntClosedMapFunction map : this.maps) {
            if (map == null) continue;
            try {
                map.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void switchToSeqAccess(File fileOutputDir) throws IOException {
        boolean msgWritten = false;
        long start = System.currentTimeMillis();
        for (Long2IntClosedMapFunction map : this.maps) {
            if (map == null) continue;
            if (!msgWritten) {
                System.out.println("Writing results of MultiTileAnalyser to temp files ...");
                msgWritten = true;
            }
            map.switchToSeqAccess(fileOutputDir);
        }
        System.out.println("Writing temp files took " + (System.currentTimeMillis() - start) + " ms");
    }

    public void finish() {
        for (Long2IntClosedMapFunction map : this.maps) {
            if (map == null) continue;
            map.finish();
        }
    }

    public void stats(String prefix) {
        for (Long2IntClosedMapFunction map : this.maps) {
            if (map == null) continue;
            map.stats(prefix);
        }
    }

    public OSMWriter[] getWriters() {
        return this.writers;
    }

    public void storeRelationAreas(long id, AreaSet areaSet) {
        this.oneDistinctAreaOnlyRels.put(id, this.areaDictionary.translate(areaSet));
    }

    public Integer getOneTileOnlyRels(long id) {
        return this.oneTileOnlyRels.get(id);
    }

    public void translateDistinctToRealAreas(DataStorer distinctDataStorer) {
        List<Area> distinctAreas = distinctDataStorer.getAreaDictionary().getAreas();
        HashMap<Area, Integer> map = new HashMap<Area, Integer>();
        for (Area distinctArea : distinctAreas) {
            if (distinctArea.isPseudoArea()) continue;
            AreaSet w = new AreaSet();
            for (int i = 0; i < this.getNumOfAreas(); ++i) {
                if (!this.areaDictionary.getArea(i).contains(distinctArea)) continue;
                w.set(i);
            }
            map.put(distinctArea, this.areaDictionary.translate(w));
        }
        for (Map.Entry e : distinctDataStorer.oneDistinctAreaOnlyRels.entrySet()) {
            AreaSet singleArea = distinctDataStorer.getAreaDictionary().getSet((Integer)e.getValue());
            assert (singleArea.cardinality() == 1);
            int pos = singleArea.iterator().next();
            if (!distinctAreas.get(pos).isPseudoArea()) {
                Integer areaIdx = (Integer)map.get(distinctAreas.get(pos));
                if (areaIdx == null) {
                    throw new SplitFailedException("failed to find index for area " + distinctAreas.get(pos));
                }
                this.oneTileOnlyRels.put((Long)e.getKey(), areaIdx);
                continue;
            }
            this.oneTileOnlyRels.put((Long)e.getKey(), (Integer)Short.MIN_VALUE);
        }
    }
}

