/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Iterator;

public final class AreaSet
implements Iterable<Integer> {
    private static final int BIN_SEARCH_LIMIT = 10;
    private final IntArrayList list;
    private boolean locked;

    public AreaSet() {
        this.list = new IntArrayList();
    }

    public AreaSet(AreaSet other) {
        this.list = !other.isEmpty() ? new IntArrayList(other.list) : new IntArrayList();
    }

    AreaSet(int index) {
        this.list = new IntArrayList();
        this.list.add(index);
    }

    public void lock() {
        this.list.trim();
        this.locked = true;
    }

    public boolean get(int index) {
        if (this.list.size() < 10) {
            return this.list.contains(index);
        }
        return Arrays.binarySearch(this.list.elements(), 0, this.list.size(), index) >= 0;
    }

    public void set(int index) {
        if (this.locked) {
            throw new IllegalAccessError("AreaSet is locked");
        }
        if (this.list.isEmpty()) {
            this.list.add(index);
        } else {
            int p = Arrays.binarySearch(this.list.elements(), 0, this.list.size(), index);
            if (p < 0) {
                this.list.add(-p - 1, index);
            }
        }
    }

    public void clear(int index) {
        if (this.locked) {
            throw new IllegalAccessError("AreaSet is locked");
        }
        if (this.list.size() < 10) {
            this.list.rem(index);
        } else {
            int pos = Arrays.binarySearch(this.list.elements(), 0, this.list.size(), index);
            if (pos >= 0) {
                this.list.removeInt(pos);
            }
        }
    }

    void or(AreaSet other) {
        if (this.locked) {
            throw new IllegalAccessError("AreaSet is locked");
        }
        if (other.isEmpty()) {
            return;
        }
        if (this.list.isEmpty()) {
            this.list.addAll(other.list);
        } else {
            IntListIterator intListIterator = other.list.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                this.set(i);
            }
        }
    }

    public void subtract(AreaSet other) {
        if (this.locked) {
            throw new IllegalAccessError("AreaSet is locked");
        }
        IntListIterator intListIterator = other.list.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            this.clear(i);
        }
    }

    public int cardinality() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    public void clear() {
        if (this.locked) {
            throw new IllegalAccessError("AreaSet is locked");
        }
        this.list.clear();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.list.iterator();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AreaSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AreaSet other = (AreaSet)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.list.equals(other.list);
    }

    public String toString() {
        return this.list.toString();
    }
}

