/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.util.BitSet;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.AreaDictionary;
import uk.me.parabola.splitter.AreaGridResult;
import uk.me.parabola.splitter.AreaIndex;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.Node;

public class AreaGrid
implements AreaIndex {
    private final Grid grid;
    protected final AreaGridResult r;
    protected final AreaDictionary areaDictionary;

    AreaGrid(AreaDictionary areaDictionary) {
        this.areaDictionary = areaDictionary;
        this.r = new AreaGridResult();
        this.grid = new Grid(null, null);
    }

    @Override
    public Area getBounds() {
        return this.grid.getBounds();
    }

    @Override
    public AreaGridResult get(Node n) {
        return this.grid.get(n.getMapLat(), n.getMapLon());
    }

    @Override
    public AreaGridResult get(int lat, int lon) {
        return this.grid.get(lat, lon);
    }

    private class Grid {
        private static final int TOP_GRID_DIM_LON = 512;
        private static final int TOP_GRID_DIM_LAT = 512;
        private static final int SUB_GRID_DIM_LON = 32;
        private static final int SUB_GRID_DIM_LAT = 32;
        private static final int MIN_GRID_LAT = 2048;
        private static final int MIN_GRID_LON = 2048;
        private static final int MAX_TESTS = 10;
        private int gridDivLon;
        private int gridDivLat;
        private int gridMinLat;
        private int gridMinLon;
        private Area bounds = null;
        private int[][] indexGrid;
        private BitSet[] testGrid;
        private Grid[][] subGrid = null;
        private final int maxCompares;
        private int usedSubGridElems = 0;
        private final int gridDimLon;
        private final int gridDimLat;

        public Grid(AreaSet usedAreas, Area bounds) {
            if (usedAreas == null) {
                this.gridDimLon = 512;
                this.gridDimLat = 512;
            } else {
                this.gridDimLon = 32;
                this.gridDimLat = 32;
            }
            this.indexGrid = new int[this.gridDimLon + 1][this.gridDimLat + 1];
            this.testGrid = new BitSet[this.gridDimLon + 1];
            for (int lon = 0; lon < this.testGrid.length; ++lon) {
                this.testGrid[lon] = new BitSet(this.gridDimLat + 1);
            }
            this.bounds = bounds;
            this.maxCompares = this.fillGrid(usedAreas);
        }

        public Area getBounds() {
            return this.bounds;
        }

        private int fillGrid(AreaSet usedAreas) {
            if (this.bounds == null) {
                Area tmpBounds = null;
                for (int i = 0; i < AreaGrid.this.areaDictionary.getNumOfAreas(); ++i) {
                    Area extBounds = AreaGrid.this.areaDictionary.getExtendedArea(i);
                    if (usedAreas != null && !usedAreas.get(i)) continue;
                    tmpBounds = tmpBounds == null ? extBounds : tmpBounds.add(extBounds);
                }
                if (tmpBounds == null) {
                    return 0;
                }
                this.bounds = new Area(tmpBounds.getMinLat(), tmpBounds.getMinLong(), tmpBounds.getMaxLat(), tmpBounds.getMaxLong());
            }
            this.gridMinLon = this.bounds.getMinLong();
            this.gridMinLat = this.bounds.getMinLat();
            int gridWidth = this.bounds.getWidth();
            int gridHeight = this.bounds.getHeight();
            this.gridDivLon = Math.round((float)(gridWidth / this.gridDimLon) + 0.5f);
            this.gridDivLat = Math.round((float)(gridHeight / this.gridDimLat) + 0.5f);
            int gridStepLon = Math.round((float)(gridWidth / this.gridDimLon) + 0.5f);
            int gridStepLat = Math.round((float)(gridHeight / this.gridDimLat) + 0.5f);
            assert (gridStepLon * this.gridDimLon >= gridWidth) : "gridStepLon is too small";
            assert (gridStepLat * this.gridDimLat >= gridHeight) : "gridStepLat is too small";
            int maxAreaSearch = 0;
            AreaSet[][] gridAreas = new AreaSet[this.gridDimLon + 1][this.gridDimLat + 1];
            for (int j = 0; j < AreaGrid.this.areaDictionary.getNumOfAreas(); ++j) {
                Area extBounds = AreaGrid.this.areaDictionary.getExtendedArea(j);
                if (usedAreas != null && !usedAreas.get(j)) continue;
                int minLonArea = extBounds.getMinLong();
                int maxLonArea = extBounds.getMaxLong();
                int minLatArea = extBounds.getMinLat();
                int maxLatArea = extBounds.getMaxLat();
                int startLon = Math.max(0, (minLonArea - this.gridMinLon) / this.gridDivLon);
                int endLon = Math.min(this.gridDimLon, (maxLonArea - this.gridMinLon) / this.gridDivLon);
                int startLat = Math.max(0, (minLatArea - this.gridMinLat) / this.gridDivLat);
                int endLat = Math.min(this.gridDimLat, (maxLatArea - this.gridMinLat) / this.gridDivLat);
                for (int lon = startLon; lon <= endLon; ++lon) {
                    int testMinLon = this.gridMinLon + gridStepLon * lon;
                    for (int lat = startLat; lat <= endLat; ++lat) {
                        int testMinLat = this.gridMinLat + gridStepLat * lat;
                        if (gridAreas[lon][lat] == null) {
                            gridAreas[lon][lat] = new AreaSet();
                        }
                        gridAreas[lon][lat].set(j);
                        if (extBounds.contains(testMinLat, testMinLon) && extBounds.contains(testMinLat + gridStepLat, testMinLon + gridStepLon)) continue;
                        this.testGrid[lon].set(lat);
                    }
                }
            }
            for (int lon = 0; lon <= this.gridDimLon; ++lon) {
                for (int lat = 0; lat <= this.gridDimLat; ++lat) {
                    AreaSet areaSet = gridAreas[lon][lat];
                    if (areaSet == null) {
                        this.indexGrid[lon][lat] = Short.MIN_VALUE;
                        continue;
                    }
                    areaSet.lock();
                    if (this.testGrid[lon].get(lat)) {
                        int numTests = areaSet.cardinality();
                        if (numTests > 10 && gridStepLat > 2048 && gridStepLon > 2048) {
                            Area gridPart = new Area(this.gridMinLat + gridStepLat * lat, this.gridMinLon + gridStepLon * lon, this.gridMinLat + gridStepLat * (lat + 1), this.gridMinLon + gridStepLon * (lon + 1));
                            if (this.subGrid == null) {
                                this.subGrid = new Grid[this.gridDimLon + 1][this.gridDimLat + 1];
                            }
                            ++this.usedSubGridElems;
                            this.subGrid[lon][lat] = new Grid(areaSet, gridPart);
                            numTests = this.subGrid[lon][lat].getMaxCompares() + 1;
                            maxAreaSearch = Math.max(maxAreaSearch, numTests);
                            continue;
                        }
                        maxAreaSearch = Math.max(maxAreaSearch, numTests);
                    }
                    this.indexGrid[lon][lat] = AreaGrid.this.areaDictionary.translate(areaSet);
                }
            }
            System.out.println("AreaGridTree [" + this.gridDimLon + "][" + this.gridDimLat + "] for grid area " + this.bounds + " requires max. " + maxAreaSearch + " checks for each node (" + this.usedSubGridElems + " sub grid(s))");
            return maxAreaSearch;
        }

        private int getMaxCompares() {
            return this.maxCompares;
        }

        public AreaGridResult get(int lat, int lon) {
            Grid sub;
            if (!this.bounds.contains(lat, lon)) {
                return null;
            }
            int gridLonIdx = (lon - this.gridMinLon) / this.gridDivLon;
            int gridLatIdx = (lat - this.gridMinLat) / this.gridDivLat;
            if (this.subGrid != null && (sub = this.subGrid[gridLonIdx][gridLatIdx]) != null) {
                return sub.get(lat, lon);
            }
            int idx = this.indexGrid[gridLonIdx][gridLatIdx];
            if (idx == Short.MIN_VALUE) {
                return null;
            }
            AreaGrid.this.r.testNeeded = this.testGrid[gridLonIdx].get(gridLatIdx);
            AreaGrid.this.r.set = AreaGrid.this.areaDictionary.getSet(idx);
            return AreaGrid.this.r;
        }
    }
}

