/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;

public class AreaDictionary {
    private static final int DICT_START = Short.MAX_VALUE;
    private final Area[] areas;
    private final ArrayList<AreaSet> sets;
    private final int numOfAreas;
    private final HashMap<AreaSet, Integer> index;
    private final HashSet<AreaSet> simpleNeighbours = new HashSet();
    private final int overlapAmount;

    AreaDictionary(List<Area> areas, int overlapAmount) {
        this.areas = areas.toArray(new Area[areas.size()]);
        this.overlapAmount = overlapAmount;
        this.numOfAreas = areas.size();
        this.sets = new ArrayList();
        this.index = new HashMap(areas.size() * 4, 0.5f);
        this.init();
    }

    private void init() {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>(this.numOfAreas);
        ArrayList<AreaSet> areaSets = new ArrayList<AreaSet>(this.numOfAreas);
        for (int i = 0; i < this.numOfAreas; ++i) {
            AreaSet b = new AreaSet(i);
            this.translate(b);
            rectangles.add(Utils.area2Rectangle(this.areas[i], 0));
            areaSets.add(b);
        }
        this.findSimpleNeigbours(rectangles, areaSets);
        System.out.println("cached " + this.simpleNeighbours.size() + " combinations of areas that form rectangles.");
    }

    public Integer translate(AreaSet areaSet) {
        Integer combiIndex = this.index.get(areaSet);
        if (combiIndex == null) {
            combiIndex = this.sets.size() - Short.MAX_VALUE;
            if (combiIndex == Integer.MAX_VALUE) {
                throw new SplitFailedException("areaDictionary is full. Try to decrease number of areas.");
            }
            AreaSet set = new AreaSet(areaSet);
            set.lock();
            this.sets.add(set);
            this.index.put(set, combiIndex);
            if (this.sets.size() % 1000 == 0) {
                System.out.println("dictionary contains now " + Utils.format(this.sets.size()) + " entries");
            }
        }
        return combiIndex;
    }

    private void findSimpleNeigbours(ArrayList<Rectangle> rectangles, ArrayList<AreaSet> areaSets) {
        ArrayList<Rectangle> newRectangles = new ArrayList<Rectangle>();
        ArrayList<AreaSet> newAreaSets = new ArrayList<AreaSet>();
        for (int i = 0; i < rectangles.size(); ++i) {
            Rectangle r1 = rectangles.get(i);
            for (int j = i + 1; j < rectangles.size(); ++j) {
                boolean isSimple;
                Rectangle r2 = rectangles.get(j);
                boolean bl = isSimple = r1.y == r2.y && r1.height == r2.height && ((double)r1.x == r2.getMaxX() || (double)r2.x == r1.getMaxX()) || r1.x == r2.x && r1.width == r2.width && ((double)r1.y == r2.getMaxY() || (double)r2.y == r1.getMaxY());
                if (!isSimple) continue;
                AreaSet simpleNeighbour = new AreaSet(areaSets.get(i));
                simpleNeighbour.or(areaSets.get(j));
                if (simpleNeighbour.cardinality() > 10 || this.simpleNeighbours.contains(simpleNeighbour)) continue;
                this.simpleNeighbours.add(simpleNeighbour);
                Rectangle pair = new Rectangle(r1);
                pair.add(r2);
                newRectangles.add(pair);
                newAreaSets.add(simpleNeighbour);
            }
        }
        if (!newRectangles.isEmpty()) {
            rectangles.addAll(newRectangles);
            areaSets.addAll(newAreaSets);
            newRectangles = null;
            newAreaSets = null;
            if (this.simpleNeighbours.size() < 1000) {
                this.findSimpleNeigbours(rectangles, areaSets);
            }
        }
    }

    public AreaSet getSet(int idx) {
        return this.sets.get(Short.MAX_VALUE + idx);
    }

    public int size() {
        return this.sets.size();
    }

    public int getNumOfAreas() {
        return this.numOfAreas;
    }

    public boolean mayCross(AreaSet areaSet) {
        return !this.simpleNeighbours.contains(areaSet);
    }

    public Area getArea(int idx) {
        return this.areas[idx];
    }

    public Area getExtendedArea(int idx) {
        Area bounds = this.areas[idx];
        if (this.overlapAmount == 0) {
            return bounds;
        }
        return new Area(bounds.getMinLat() - this.overlapAmount, bounds.getMinLong() - this.overlapAmount, bounds.getMaxLat() + this.overlapAmount, bounds.getMaxLong() + this.overlapAmount);
    }

    public List<Area> getAreas() {
        return Collections.unmodifiableList(Arrays.asList(this.areas));
    }

    public static int translate(int singleWriterId) {
        return singleWriterId - Short.MAX_VALUE;
    }
}

