/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class BufferedImgFileReader
implements ImgFileReader {
    private static final Logger log = Logger.getLogger(BufferedImgFileReader.class);
    private static final int BUF_SIZE = 4096;
    private final ImgChannel chan;
    private final ByteBuffer buf = ByteBuffer.allocate(4096);
    private long bufStart;
    private int bufSize = -1;
    private long position;
    private final int gmpOffset;

    public BufferedImgFileReader(ImgChannel chan) {
        this(chan, 0);
    }

    public BufferedImgFileReader(ImgChannel chan, int gmpOffset) {
        this.chan = chan;
        this.gmpOffset = gmpOffset;
    }

    @Override
    public int getGMPOffset() {
        return this.gmpOffset;
    }

    @Override
    public void close() throws IOException {
        this.chan.close();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long pos) {
        this.position = pos;
    }

    @Override
    public byte get() throws ReadFailedException {
        this.fillBuffer();
        int pos = (int)(this.position - this.bufStart);
        if (pos >= this.bufSize) {
            return 0;
        }
        ++this.position;
        return this.buf.get(pos);
    }

    @Override
    public int get1s() throws ReadFailedException {
        return this.get();
    }

    @Override
    public int get2s() throws ReadFailedException {
        byte b1 = this.get();
        byte b2 = this.get();
        return b1 & 0xFF | b2 << 8;
    }

    @Override
    public int get3s() throws ReadFailedException {
        byte b1 = this.get();
        byte b2 = this.get();
        byte b3 = this.get();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | b3 << 16;
    }

    @Override
    public int get1u() throws ReadFailedException {
        return this.get() & 0xFF;
    }

    @Override
    public int get2u() throws ReadFailedException {
        byte b1 = this.get();
        byte b2 = this.get();
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }

    @Override
    public int get3u() throws ReadFailedException {
        byte b1 = this.get();
        byte b2 = this.get();
        byte b3 = this.get();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16;
    }

    @Override
    public int getNu(int nBytes) throws ReadFailedException {
        switch (nBytes) {
            case 1: {
                return this.get1u();
            }
            case 2: {
                return this.get2u();
            }
            case 3: {
                return this.get3u();
            }
            case 4: {
                return this.get4();
            }
        }
        throw new MapFailedException("bad integer size " + nBytes);
    }

    @Override
    public int get4() throws ReadFailedException {
        byte b1 = this.get();
        byte b2 = this.get();
        byte b3 = this.get();
        byte b4 = this.get();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | b4 << 24;
    }

    @Override
    public byte[] get(int len) throws ReadFailedException {
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.get();
        }
        return bytes;
    }

    @Override
    public byte[] getZString() throws ReadFailedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte b = this.get();
        while (b != 0) {
            out.write(b);
            b = this.get();
        }
        return out.toByteArray();
    }

    @Override
    public String getBase11str(byte firstChar, char delimiter) {
        StringBuilder str11 = new StringBuilder();
        int term = 2;
        int ch = firstChar & 0xFF;
        do {
            assert (str11.length() != 0 || (ch & 0x80) != 0);
            if ((ch & 0x80) != 0) {
                --term;
            }
            str11.append(this.base(ch & 0x7F, 11, 2));
            if (term == 0) continue;
            ch = this.get();
        } while (term != 0);
        while (str11.length() > 0 && str11.charAt(str11.length() - 1) == 'A') {
            str11.setLength(str11.length() - 1);
        }
        int len = str11.length();
        for (int i = 0; i < len; ++i) {
            if (str11.charAt(i) != 'A') continue;
            str11.setCharAt(i, delimiter);
        }
        return str11.toString();
    }

    private String base(int inNum, int base, int width) {
        StringBuilder val = new StringBuilder();
        if (base < 2 || base > 36 || width < 1) {
            return "";
        }
        String digit = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (int num = inNum; num != 0; num /= base) {
            val.append(digit.charAt(num % base));
        }
        while (val.length() < width) {
            val.append('0');
        }
        val.reverse();
        return val.toString();
    }

    private void fillBuffer() throws ReadFailedException {
        if (this.position < this.bufStart || this.position >= this.bufStart + (long)this.bufSize) {
            this.bufStart = this.position & 0xFFFFFFFFFFFFF000L;
            this.chan.position(this.bufStart);
            log.debug("reading in a buffer start=", this.bufStart);
            this.buf.clear();
            this.bufSize = 0;
            try {
                this.bufSize = this.chan.read(this.buf);
            }
            catch (IOException e) {
                throw new ReadFailedException("failed to fill buffer", e);
            }
            log.debug("there were", this.bufSize, "bytes read");
        }
    }
}

