/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryGrid;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.EnhancedProperties;

public class LocationHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(LocationHook.class);
    private static final Logger resultLog = Logger.getLogger(LocationHook.class.getName() + ".results");
    private long cntQTSearch = 0L;
    private long cntNotFnd = 0L;
    private long cntwayNotFnd = 0L;
    private BoundaryGrid boundaryGrid;
    private ElementSaver saver;
    private String boundaryDirName;
    private static final Object BOUNDS_CHECK_LOCK = new Object();
    private static String checkedBoundaryDirName;
    private static boolean checkBoundaryDirOk;
    private EnhancedProperties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.boundaryDirName = props.getProperty("bounds");
        if (this.boundaryDirName == null) {
            return false;
        }
        this.props = props;
        this.saver = saver;
        long t1 = System.currentTimeMillis();
        Object object = BOUNDS_CHECK_LOCK;
        synchronized (object) {
            if (this.boundaryDirName.equals(checkedBoundaryDirName)) {
                if (!checkBoundaryDirOk) {
                    log.error((Object)("Disable LocationHook because bounds directory is unusable. Dir: " + this.boundaryDirName));
                    return false;
                }
            } else {
                checkedBoundaryDirName = this.boundaryDirName;
                checkBoundaryDirOk = false;
                List<String> boundaryFiles = BoundaryUtil.getBoundaryDirContent(this.boundaryDirName);
                if (boundaryFiles == null || boundaryFiles.isEmpty()) {
                    log.error((Object)("LocationHook is disabled because no bounds files are available. Dir: " + this.boundaryDirName));
                    return false;
                }
                checkBoundaryDirOk = true;
            }
        }
        log.info("Checking bounds dir took", System.currentTimeMillis() - t1, "ms");
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Starting with location hook");
        Area nodesBounds = this.saver.getDataBoundingBox();
        if (nodesBounds != null) {
            Area bbox = this.saver.getBoundingBox();
            Area searchBounds = bbox.intersect(nodesBounds);
            this.boundaryGrid = new BoundaryGrid(this.boundaryDirName, searchBounds, this.props);
            this.processLocationRelevantElements();
            this.boundaryGrid = null;
        }
        long dt = System.currentTimeMillis() - t1;
        log.info((Object)"======= LocationHook Stats =====");
        log.info("QuadTree searches    :", this.cntQTSearch);
        log.info("unsuccesfull         :", this.cntNotFnd);
        log.info("unsuccesfull for ways:", this.cntwayNotFnd);
        log.info("Location hook finished in", dt, "ms");
    }

    private void processLocationRelevantElements() {
        for (Node node : this.saver.getNodes().values()) {
            if (node.getTagCount() <= 0 || !this.saver.getBoundingBox().contains(node.getLocation())) continue;
            this.processElem(node);
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("N", node.getId(), LocationHook.locationTagsToString(node));
        }
        for (Way way : this.saver.getWays().values()) {
            if (way.getTagCount() <= 0) continue;
            this.processElem(way);
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("W", way.getId(), LocationHook.locationTagsToString(way));
        }
        for (Relation r : this.saver.getRelations().values()) {
            Coord mpCenter;
            if (!(r instanceof MultiPolygonRelation) || (mpCenter = ((MultiPolygonRelation)r).getCofG()) == null || !this.saver.getBoundingBox().contains(mpCenter)) continue;
            Node mpNode = new Node(r.getOriginalId(), mpCenter);
            mpNode.markAsGeneratedFrom(r);
            this.processElem(mpNode);
            for (String boundsTag : BoundaryQuadTree.mkgmapTagsArray) {
                String tagValue = mpNode.getTag(boundsTag);
                if (tagValue == null) continue;
                r.addTag(boundsTag, tagValue);
            }
            if (!resultLog.isDebugEnabled()) continue;
            resultLog.debug("R", r.getId(), LocationHook.locationTagsToString(r));
        }
    }

    private void processElem(Element elem) {
        Tags tags = null;
        if (elem instanceof Node) {
            Node node = (Node)elem;
            tags = this.search(node.getLocation());
        } else if (elem instanceof Way && (tags = this.processWayPoints(((Way)elem).getPoints())) == null) {
            ++this.cntwayNotFnd;
        }
        if (tags == null) {
            ++this.cntNotFnd;
        } else {
            Iterator<Map.Entry<Short, String>> tagIter = tags.entryShortIterator();
            while (tagIter.hasNext()) {
                Map.Entry<Short, String> tag = tagIter.next();
                if (elem.getTag(tag.getKey()) != null) continue;
                elem.addTag(tag.getKey(), tag.getValue());
            }
        }
    }

    private Tags processWayPoints(List<Coord> points) {
        int n = points.size();
        int middle = n / 2;
        Coord midPoint = n == 2 ? points.get(0).makeBetweenPoint(points.get(1), 0.5) : points.get(middle);
        Tags tags = this.search(midPoint);
        if (tags == null) {
            tags = this.search(points.get(0));
        }
        if (tags == null) {
            tags = this.search(points.get(n - 1));
        }
        if (tags == null) {
            for (int i = 1; i < n - 1 && (i == middle || (tags = this.search(points.get(i))) == null); ++i) {
            }
        }
        return tags;
    }

    private Tags search(Coord co) {
        if (this.saver.getBoundingBox().contains(co)) {
            ++this.cntQTSearch;
            return this.boundaryGrid.get(co);
        }
        return null;
    }

    private static String locationTagsToString(Element elem) {
        StringBuilder res = new StringBuilder();
        for (int i = BoundaryQuadTree.mkgmapTagsArray.length - 1; i >= 0; --i) {
            String tagVal = elem.getTag(BoundaryQuadTree.mkgmapTagsArray[i]);
            if (tagVal != null) {
                res.append(tagVal);
            }
            res.append(";");
        }
        return res.toString();
    }
}

