/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.map.MapReader;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.tdbfmt.DetailMapBlock;
import uk.me.parabola.tdbfmt.TdbFile;

public class TdbBuilder
implements Combiner {
    private static final Logger log = Logger.getLogger(TdbBuilder.class);
    private final OverviewBuilder overviewBuilder;
    private TdbFile tdb;
    private int parent = 63240000;
    private String overviewMapname;
    private String overviewMapnumber;
    private String outputDir;
    private int tdbVersion;
    private final List<String[]> copyrightMsgs = new ArrayList<String[]>();

    public TdbBuilder(OverviewBuilder ovb) {
        this.overviewBuilder = ovb;
    }

    @Override
    public void init(CommandArgs args) {
        this.overviewMapname = args.get("overview-mapname", "osmmap");
        this.overviewMapnumber = args.get("overview-mapnumber", "63240000");
        try {
            this.parent = Integer.parseInt(this.overviewMapnumber);
        }
        catch (NumberFormatException e) {
            log.debug("overview map number not an integer", this.overviewMapnumber);
        }
        String areaName = args.get("area-name", "Overview Map");
        int familyId = args.get("family-id", 6324);
        int productId = args.get("product-id", 1);
        short productVersion = (short)args.get("product-version", 100);
        String seriesName = args.get("series-name", "OSM map");
        String familyName = args.get("family-name", "OSM map");
        this.tdbVersion = 407;
        byte enableProfile = (byte)args.get("show-profiles", 0);
        this.tdb = new TdbFile(this.tdbVersion);
        this.tdb.setProductInfo(familyId, productId, productVersion, seriesName, familyName, areaName, enableProfile);
        this.tdb.setCodePage(args.getCodePage());
        this.outputDir = args.getOutputDir();
    }

    @Override
    public void onMapEnd(FileInfo info) {
        if (!info.isImg()) {
            return;
        }
        this.addToTdb(info);
    }

    private void addToTdb(FileInfo finfo) {
        Object[] msgs;
        DetailMapBlock detail = new DetailMapBlock(this.tdbVersion);
        detail.setArea(finfo.getBounds());
        String mapname = finfo.getMapname();
        String mapdesc = finfo.getDescription();
        detail.setMapName(mapname);
        String desc = mapdesc + " (" + mapname + ')';
        detail.setDescription(desc);
        detail.setSubFiles(finfo.subFiles());
        log.info("overview-mapname", this.overviewMapname);
        log.info("overview-mapnumber", this.parent);
        detail.setParentMapNumber(this.parent);
        this.tdb.addDetail(detail);
        for (String string : msgs = finfo.getLicenseInfo()) {
            this.tdb.addCopyright(string);
        }
        String filename = finfo.getFilename();
        try {
            MapReader mapReader = finfo.getMapReader();
            msgs = mapReader.getCopyrights();
            boolean found = false;
            for (Object[] objectArray : this.copyrightMsgs) {
                if (!Arrays.deepEquals(objectArray, msgs)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.copyrightMsgs.add((String[])msgs);
                for (Object m : msgs) {
                    this.tdb.addCopyright((String)m);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ExitException("Could not open " + filename + " when creating tdb file");
        }
    }

    @Override
    public void onFinish() {
        log.debug((Object)"finishing overview");
        this.tdb.setOverview(this.overviewBuilder.getBounds(), this.overviewMapnumber);
        this.writeTdbFile();
    }

    @Override
    public String getFilename() {
        return Utils.joinPath(this.outputDir, this.overviewMapname, "tdb");
    }

    private void writeTdbFile() {
        try {
            this.tdb.write(Utils.joinPath(this.outputDir, this.overviewMapname, "tdb"));
        }
        catch (IOException e) {
            throw new ExitException("Could not write the TDB file", e);
        }
    }
}

