/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.reader.osm.Tags;

public class LocatorConfig {
    private static final Logger log = Logger.getLogger(LocatorConfig.class);
    private final Map<String, String> isoMap = new HashMap<String, String>();
    private final Map<String, Integer> regOffsetMap = new HashMap<String, Integer>();
    private final Map<String, Integer> poiDispFlagMap = new HashMap<String, Integer>();
    private final Map<String, Boolean> driveOnLeftFlagMap = new HashMap<String, Boolean>();
    private final Set<String> continents = new HashSet<String>();
    private final Map<String, String> defaultCountryNames = new HashMap<String, String>();
    private final Map<String, Tags> countryTagMap = new HashMap<String, Tags>();
    private static final LocatorConfig instance = new LocatorConfig();

    public static LocatorConfig get() {
        return instance;
    }

    private LocatorConfig() {
        this.loadConfig("/LocatorConfig.xml");
    }

    private void loadConfig(String fileName) {
        try {
            Document document;
            Element rootNode;
            InputStream inStream;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            try {
                inStream = new FileInputStream("resources/" + fileName);
            }
            catch (Exception ex) {
                inStream = null;
            }
            if (inStream == null) {
                inStream = this.getClass().getResourceAsStream(fileName);
            }
            if ("locator".equals((rootNode = (document = builder.parse(inStream)).getDocumentElement()).getNodeName())) {
                for (Node cNode = rootNode.getFirstChild(); cNode != null; cNode = cNode.getNextSibling()) {
                    Node nameTag;
                    NamedNodeMap attr;
                    if ("continent".equals(cNode.getNodeName()) && (attr = cNode.getAttributes()) != null && (nameTag = attr.getNamedItem("name")) != null) {
                        this.addContinent(nameTag.getNodeValue());
                    }
                    if (!"country".equals(cNode.getNodeName())) continue;
                    attr = cNode.getAttributes();
                    String iso = null;
                    if (attr != null) {
                        Node driveOnLeft;
                        Node postalcodeBeforeCity;
                        Node regionOffsetTag;
                        Node nameTag2 = null;
                        Node abrTag = attr.getNamedItem("abr");
                        if (abrTag != null && (iso = abrTag.getNodeValue().toUpperCase().trim().intern()).length() != 3) {
                            log.error((Object)("ISO code (abr) must have three characters: " + iso));
                        }
                        nameTag2 = attr.getNamedItem("name");
                        if (iso != null && nameTag2 != null) {
                            this.addISO(nameTag2.getNodeValue(), iso);
                            this.defaultCountryNames.put(iso, nameTag2.getNodeValue().trim());
                        }
                        if (iso != null) {
                            this.addISO(iso, iso);
                        }
                        if (iso == null && nameTag2 != null) {
                            this.addISO(nameTag2.getNodeValue(), "");
                        }
                        if ((regionOffsetTag = attr.getNamedItem("regionOffset")) != null && iso != null) {
                            this.addRegionOffset(iso, Integer.parseInt(regionOffsetTag.getNodeValue()));
                        }
                        int poiDispTag = 0;
                        Node streetBeforeHousenumber = attr.getNamedItem("streetBeforeHousenumber");
                        if (streetBeforeHousenumber != null && "true".equals(streetBeforeHousenumber.getNodeValue())) {
                            poiDispTag |= 4;
                        }
                        if ((postalcodeBeforeCity = attr.getNamedItem("postalcodeBeforeCity")) != null && "true".equals(postalcodeBeforeCity.getNodeValue())) {
                            poiDispTag |= 8;
                        }
                        if (poiDispTag != 0 && iso != null) {
                            this.setPoiDispTag(iso, poiDispTag);
                        }
                        this.driveOnLeftFlagMap.put(iso, (driveOnLeft = attr.getNamedItem("driveOnLeft")) != null && "true".equals(driveOnLeft.getNodeValue()));
                    }
                    if (iso == null) continue;
                    for (Node cEntryNode = cNode.getFirstChild(); cEntryNode != null; cEntryNode = cEntryNode.getNextSibling()) {
                        Node nodeText;
                        if (!"variant".equals(cEntryNode.getNodeName()) || (nodeText = cEntryNode.getFirstChild()) == null) continue;
                        this.addISO(nodeText.getNodeValue(), iso);
                    }
                }
            } else {
                log.error((Object)(fileName + "contains invalid root tag " + rootNode.getNodeName()));
            }
        }
        catch (Exception ex) {
            Logger.defaultLogger.error((Object)("Unexpected error reading " + fileName), ex);
        }
    }

    private void addISO(String country, String iso) {
        String cStr = country.toUpperCase().trim();
        this.isoMap.put(cStr, iso);
    }

    private void addRegionOffset(String iso, Integer offset) {
        this.regOffsetMap.put(iso, offset);
    }

    private void setPoiDispTag(String iso, int flag) {
        this.poiDispFlagMap.put(iso, flag & 0xC);
    }

    private void addContinent(String continent) {
        String cStr = continent.toUpperCase().trim();
        this.continents.add(cStr);
    }

    public synchronized void setDefaultCountry(String country, String abbr) {
        this.addISO(country, abbr);
    }

    public synchronized boolean isCountry(String country) {
        return this.isoMap.containsKey(country.toUpperCase().trim());
    }

    public synchronized boolean countryHasTags(String isoCode) {
        return this.countryTagMap.containsKey(isoCode);
    }

    public synchronized String addCountryWithTags(String isoCode, Tags countryTags) {
        String int_name;
        if (isoCode == null) {
            log.warn("Cannot find country with tags", countryTags);
            return null;
        }
        if (this.countryHasTags(isoCode)) {
            return isoCode;
        }
        this.countryTagMap.put(isoCode, countryTags.copy());
        String name = countryTags.get("name");
        if (name != null) {
            this.addISO(name, isoCode);
        }
        if ((int_name = countryTags.get("int_name")) != null) {
            this.addISO(int_name, isoCode);
        }
        for (String countryName : countryTags.getTagsWithPrefix("name:", false).values()) {
            this.addISO(countryName, isoCode);
        }
        return isoCode;
    }

    public synchronized String getCountryISOCode(String country) {
        if (country == null) {
            return null;
        }
        String res = this.isoMap.get(country);
        if (res == null && (res = this.isoMap.get(country.toUpperCase().trim())) != null) {
            this.isoMap.put(country, res);
        }
        return res;
    }

    public synchronized String getCountryName(String isoCode, NameFinder nameFinder) {
        Tags countryTags = this.countryTagMap.get(isoCode);
        if (countryTags == null) {
            return this.defaultCountryNames.get(isoCode);
        }
        return nameFinder.getName(countryTags);
    }

    public synchronized int getRegionOffset(String iso) {
        if (iso == null) {
            return 1;
        }
        Integer regOffset = this.regOffsetMap.get(iso);
        if (regOffset != null) {
            return regOffset;
        }
        return 1;
    }

    public synchronized int getPoiDispFlag(String iso) {
        if (iso == null) {
            return 0;
        }
        Integer flag = this.poiDispFlagMap.get(iso);
        if (flag != null) {
            return flag;
        }
        return 0;
    }

    public synchronized boolean isContinent(String continent) {
        String s = continent.toUpperCase().trim();
        return this.continents.contains(s);
    }

    public synchronized boolean getDriveOnLeftFlag(String iso) {
        if (iso == null) {
            return false;
        }
        Boolean driveOnLeft = this.driveOnLeftFlagMap.get(iso);
        if (driveOnLeft == null) {
            log.warn("Did not find iso code", iso, "in LocatorConfig.xml, assuming drive-on-right for it");
            this.driveOnLeftFlagMap.put(iso, false);
            return false;
        }
        return driveOnLeft;
    }
}

