/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.log.Logger;

class BlockManager {
    private static final Logger log = Logger.getLogger(BlockManager.class);
    private int blockSize;
    private int currentBlock;
    private int maxBlock = 65534;
    private int maxBlockAllocated;
    private final int initialBlock;

    BlockManager(int blockSize, int initialBlock) {
        this.blockSize = blockSize;
        this.currentBlock = initialBlock;
        this.initialBlock = initialBlock;
        this.maxBlockAllocated = initialBlock;
    }

    public int allocate() {
        int n = this.currentBlock++;
        if (this.maxBlock > 0 && n > this.maxBlock) {
            log.error((Object)("overflowed directory with max block " + this.maxBlock + ", current=" + n));
            String message = String.format("Too many blocks. Use a larger block size with an option such as --block-size=%d or --block-size=%d", this.blockSize * 2, this.blockSize * 4);
            throw new MapFailedException(message);
        }
        ++this.maxBlockAllocated;
        return n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getMaxBlock() {
        return this.maxBlock;
    }

    public void setMaxBlock(int maxBlock) {
        this.maxBlock = maxBlock;
    }

    public void setCurrentBlock(int n) {
        if (this.maxBlockAllocated != this.initialBlock) {
            throw new IllegalStateException("Blocks already allocated");
        }
        this.currentBlock = n;
        this.maxBlockAllocated = n;
    }

    public int getMaxBlockAllocated() {
        return this.maxBlockAllocated;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }
}

