/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.net.NODHeader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class NODFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(NODFile.class);
    private final NODHeader nodHeader = new NODHeader();
    private List<RouteCenter> centers = new ArrayList<RouteCenter>();
    private List<RoadDef> roads = new ArrayList<RoadDef>();
    private List<RouteNode> boundaryNodes = new ArrayList<RouteNode>();

    public NODFile(ImgChannel chan, boolean write) {
        this.setHeader(this.nodHeader);
        if (write) {
            this.setWriter(new BufferedImgFileWriter(chan, "NOD"));
            this.position(127L);
        } else {
            this.setReader(new BufferedImgFileReader(chan));
            this.nodHeader.readHeader(this.getReader());
        }
    }

    public void write() {
        this.writeNodes();
        this.writeRoadData();
        this.writeBoundary();
        this.writeHighClassBoundary();
    }

    public void writePost() {
        SectionWriter writer = new SectionWriter(this.getWriter(), this.nodHeader.getNodeSection());
        for (RouteCenter rc : this.centers) {
            rc.writePost(writer);
        }
        this.position(0L);
        this.getHeader().writeHeader(this.getWriter());
    }

    private void writeNodes() {
        ImgFileWriter writer = this.getWriter();
        this.nodHeader.setNodeStart(writer.position());
        Section section = this.nodHeader.getNodeSection();
        writer = new SectionWriter(writer, section);
        int[] classBoundaries = this.nodHeader.getClassBoundaries();
        for (RouteCenter cp : this.centers) {
            cp.write(writer, classBoundaries);
        }
        for (int i = 4; i >= 0; --i) {
            if (classBoundaries[i] <= writer.position()) continue;
            classBoundaries[i] = writer.position();
        }
        this.nodHeader.setNodeSize(writer.position());
        log.debug("the nod offset", Integer.toHexString(this.getWriter().position()));
        Section.close(writer);
    }

    private void writeRoadData() {
        log.info((Object)"writeRoadData");
        SectionWriter writer = new SectionWriter(this.getWriter(), this.nodHeader.getRoadSection());
        boolean debug = log.isDebugEnabled();
        for (RoadDef rd : this.roads) {
            if (debug) {
                log.debug("wrting nod2", writer.position());
            }
            rd.writeNod2(writer);
        }
        if (debug) {
            log.debug("ending nod2", writer.position());
        }
        this.nodHeader.setRoadSize(writer.position());
    }

    private void writeBoundary() {
        log.info((Object)"writeBoundary");
        SectionWriter writer = new SectionWriter(this.getWriter(), this.nodHeader.getBoundarySection());
        boolean debug = log.isDebugEnabled();
        for (RouteNode node : this.boundaryNodes) {
            if (debug) {
                log.debug("wrting nod3", writer.position());
            }
            node.writeNod3OrNod4(writer);
        }
        if (debug) {
            log.debug("ending nod3", writer.position());
        }
        this.nodHeader.setBoundarySize(writer.position());
    }

    private void writeHighClassBoundary() {
        log.info((Object)"writeBoundary");
        Section section = this.nodHeader.getHighClassBoundary();
        int pos = section.getPosition();
        pos = pos + 512 & 0xFFFFFE00;
        int numBytesToWrite = pos - section.getPosition();
        for (int i = 0; i < numBytesToWrite; ++i) {
            this.getWriter().put1u(0);
        }
        section.setPosition(pos);
        SectionWriter writer = new SectionWriter(this.getWriter(), section);
        boolean debug = log.isDebugEnabled();
        for (RouteNode node : this.boundaryNodes) {
            if (node.getNodeClass() == 0) continue;
            if (debug) {
                log.debug("wrting nod4", writer.position());
            }
            node.writeNod3OrNod4(writer);
        }
        if (debug) {
            log.debug("ending nod4", writer.position());
        }
        this.nodHeader.setHighClassBoundarySize(writer.position());
    }

    public void setNetwork(List<RouteCenter> centers, List<RoadDef> roads, List<RouteNode> boundary) {
        this.centers = centers;
        this.roads = roads;
        this.boundaryNodes = new ArrayList<RouteNode>(boundary);
        this.boundaryNodes.sort(null);
    }

    public void setDriveOnLeft(boolean dol) {
        this.nodHeader.setDriveOnLeft(dol);
    }
}

