/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class MDRHeader
extends CommonHeader {
    private static final int MAX_SECTIONS = 40;
    private final Section[] sections = new Section[41];
    private Sort sort;

    public MDRHeader(int headerLen) {
        super(headerLen, "GARMIN MDR");
        for (int i = 1; i < this.sections.length; ++i) {
            Section prev = i == 0 ? null : this.sections[i - 1];
            this.sections[i] = new Section(prev);
        }
        this.sections[1].setPosition(this.getHeaderLength());
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put2u(this.sort.getCodepage());
        writer.put2u(this.sort.getId1());
        writer.put2u(this.sort.getId2());
        writer.put2u(14);
        this.sections[1].writeSectionInfo(writer, true, true);
        this.sections[2].writeSectionInfo(writer, true, true);
        this.sections[3].writeSectionInfo(writer, true, true);
        this.sections[4].writeSectionInfo(writer, true, true);
        this.sections[5].writeSectionInfo(writer, true, true);
        this.sections[6].writeSectionInfo(writer, true, true);
        this.sections[7].writeSectionInfo(writer, true, true);
        this.sections[8].writeSectionInfo(writer, true, true);
        this.sections[9].writeSectionInfo(writer, true, true);
        this.sections[10].writeSectionInfo(writer, false, true);
        this.sections[11].writeSectionInfo(writer, true, true);
        this.sections[12].writeSectionInfo(writer, true, true);
        this.sections[13].writeSectionInfo(writer, true, true);
        this.sections[14].writeSectionInfo(writer, true, true);
        this.sections[15].writeSectionInfo(writer);
        writer.put1u(0);
        this.sections[16].writeSectionInfo(writer, true, true);
        this.sections[17].writeSectionInfo(writer, false, true);
        for (int n = 18; n <= 30; ++n) {
            this.sections[n].writeSectionInfo(writer, true, true);
        }
    }

    public void setItemSize(int sectionNumber, int itemSize) {
        Section section = this.sections[sectionNumber];
        section.setItemSize((char)itemSize);
    }

    public void setExtraValue(int sectionNumber, int extraValue) {
        Section section = this.sections[sectionNumber];
        section.setExtraValue(extraValue);
    }

    public void setPosition(int sectionNumber, int position) {
        this.sections[sectionNumber].setPosition(position);
    }

    public void setEnd(int sectionNumber, int position) {
        Section s = this.sections[sectionNumber];
        s.setSize(position - s.getPosition());
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }
}

