/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;

public class Area {
    private static final Logger log = Logger.getLogger(Area.class);
    public static final Area PLANET = new Area(-90.0, -180.0, 90.0, 180.0);
    private final int minLat;
    private final int minLong;
    private final int maxLat;
    private final int maxLong;

    public Area(int minLat, int minLong, int maxLat, int maxLong) {
        this.minLat = minLat;
        this.maxLat = maxLat == minLat ? minLat + 1 : maxLat;
        this.minLong = minLong;
        this.maxLong = minLong == maxLong ? maxLong + 1 : maxLong;
    }

    public Area(double minLat, double minLong, double maxLat, double maxLong) {
        this(Utils.toMapUnit(minLat), Utils.toMapUnit(minLong), Utils.toMapUnit(maxLat), Utils.toMapUnit(maxLong));
    }

    public static Area getBBox(List<Coord> points) {
        int tmpMinLat = Integer.MAX_VALUE;
        int tmpMaxLat = Integer.MIN_VALUE;
        int tmpMinLong = Integer.MAX_VALUE;
        int tmpMaxLong = Integer.MIN_VALUE;
        for (Coord co : points) {
            int lon;
            int lat = co.getLatitude();
            if (lat < tmpMinLat) {
                tmpMinLat = lat;
            }
            if (lat > tmpMaxLat) {
                tmpMaxLat = lat;
            }
            if ((lon = co.getLongitude()) < tmpMinLong) {
                tmpMinLong = lon;
            }
            if (lon <= tmpMaxLong) continue;
            tmpMaxLong = lon;
        }
        return new Area(tmpMinLat, tmpMinLong, tmpMaxLat, tmpMaxLong);
    }

    public int getMinLat() {
        return this.minLat;
    }

    public int getMinLong() {
        return this.minLong;
    }

    public int getMaxLat() {
        return this.maxLat;
    }

    public int getMaxLong() {
        return this.maxLong;
    }

    public int getWidth() {
        return this.maxLong - this.minLong;
    }

    public int getHeight() {
        return this.maxLat - this.minLat;
    }

    public Coord getCenter() {
        return new Coord((this.minLat + this.maxLat) / 2, (this.minLong + this.maxLong) / 2);
    }

    public String debugString() {
        return String.format(Locale.ROOT, "(%d, %d) to (%d, %d) (%.6f, %.6f) to (%.6f, %.6f)", this.minLat, this.minLong, this.maxLat, this.maxLong, Utils.toDegrees(this.minLat), Utils.toDegrees(this.minLong), Utils.toDegrees(this.maxLat), Utils.toDegrees(this.maxLong));
    }

    public String toString() {
        return "(" + Utils.toDegrees(this.minLat) + ',' + Utils.toDegrees(this.minLong) + ") to (" + Utils.toDegrees(this.maxLat) + ',' + Utils.toDegrees(this.maxLong) + ')';
    }

    public String toHexString() {
        return "(0x" + Integer.toHexString(this.minLat) + ",0x" + Integer.toHexString(this.minLong) + ") to (0x" + Integer.toHexString(this.maxLat) + ",0x" + Integer.toHexString(this.maxLong) + ')';
    }

    private static int roundPof2(int val, int shift) {
        if (shift <= 0) {
            return val;
        }
        return (val >> shift - 1) + 1 >> 1 << shift;
    }

    public Area[] split(int xsplit, int ysplit, int resolutionShift) {
        Area[] areas = new Area[xsplit * ysplit];
        int nAreas = 0;
        int xstart = this.minLong;
        for (int x = 0; x < xsplit; ++x) {
            int xend = x == xsplit - 1 ? this.maxLong : Area.roundPof2(xstart + (this.maxLong - xstart) / (xsplit - x), resolutionShift);
            int ystart = this.minLat;
            for (int y = 0; y < ysplit; ++y) {
                int yend = y == ysplit - 1 ? this.maxLat : Area.roundPof2(ystart + (this.maxLat - ystart) / (ysplit - y), resolutionShift);
                if (xstart < xend && ystart < yend) {
                    Area a = new Area(ystart, xstart, yend, xend);
                    log.debug("Area.split", this.minLat, this.minLong, this.maxLat, this.maxLong, "res", resolutionShift, "to", ystart, xstart, yend, xend);
                    areas[nAreas++] = a;
                } else {
                    log.warn("Area.split", this.minLat, this.minLong, this.maxLat, this.maxLong, "res", resolutionShift, "can't", xsplit, ysplit);
                }
                ystart = yend;
            }
            xstart = xend;
        }
        if (nAreas == areas.length) {
            return areas;
        }
        if (nAreas == 1) {
            return null;
        }
        if (areas.length == 1 && areas[0] == null) {
            return null;
        }
        throw new MapFailedException("Area split shift align problems");
    }

    public int getMaxDimension() {
        return Math.max(this.getWidth(), this.getHeight());
    }

    public final boolean contains(Coord co) {
        int latHp = co.getHighPrecLat();
        int lonHp = co.getHighPrecLon();
        return latHp >= this.minLat << 6 && latHp <= this.maxLat << 6 && lonHp >= this.minLong << 6 && lonHp <= this.maxLong << 6;
    }

    public final boolean contains(Area other) {
        return other.getMinLat() >= this.minLat && other.getMaxLat() <= this.maxLat && other.getMinLong() >= this.minLong && other.getMaxLong() <= this.maxLong;
    }

    public final boolean insideBoundary(Coord co) {
        int latHp = co.getHighPrecLat();
        int lonHp = co.getHighPrecLon();
        return latHp > this.minLat << 6 && latHp < this.maxLat << 6 && lonHp > this.minLong << 6 && lonHp < this.maxLong << 6;
    }

    public final boolean insideBoundary(Area other) {
        return other.getMinLat() > this.minLat && other.getMaxLat() < this.maxLat && other.getMinLong() > this.minLong && other.getMaxLong() < this.maxLong;
    }

    public final boolean onBoundary(Coord co) {
        return this.contains(co) && !this.insideBoundary(co);
    }

    public final boolean intersects(Area bbox) {
        return this.minLat <= bbox.getMaxLat() && this.maxLat >= bbox.getMinLat() && this.minLong <= bbox.getMaxLong() && this.maxLong >= bbox.getMinLong();
    }

    public boolean isEmpty() {
        return this.minLat >= this.maxLat || this.minLong >= this.maxLong;
    }

    public boolean allInsideBoundary(List<Coord> coords) {
        for (Coord co : coords) {
            if (this.insideBoundary(co)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Area area = (Area)o;
        return this.maxLat == area.maxLat && this.maxLong == area.maxLong && this.minLat == area.minLat && this.minLong == area.minLong;
    }

    public int hashCode() {
        int result = this.minLat;
        result = 31 * result + this.minLong;
        result = 31 * result + this.maxLat;
        result = 31 * result + this.maxLong;
        return result;
    }

    public List<Coord> toCoords() {
        ArrayList<Coord> coords = new ArrayList<Coord>(5);
        coords.add(new Coord(this.minLat, this.minLong));
        coords.add(new Coord(this.minLat, this.maxLong));
        coords.add(new Coord(this.maxLat, this.maxLong));
        coords.add(new Coord(this.maxLat, this.minLong));
        coords.add((Coord)coords.get(0));
        return coords;
    }

    public Area intersect(Area other) {
        return new Area(Math.max(this.minLat, other.minLat), Math.max(this.minLong, other.minLong), Math.min(this.maxLat, other.maxLat), Math.min(this.maxLong, other.maxLong));
    }
}

